/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.ContentAssessmentResult;
import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.SpeechRecognitionResult;
import com.microsoft.cognitiveservices.speech.WordLevelTimingResult;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class PronunciationAssessmentResult {
    private double accuracyScore;
    private double pronunciationScore;
    private double completenessScore;
    private double fluencyScore;
    private double prosodyScore;
    private ContentAssessmentResult contentAssessmentResult;
    private List<WordLevelTimingResult> words;

    public static PronunciationAssessmentResult fromResult(SpeechRecognitionResult speechRecognitionResult) {
        Contracts.throwIfNull(speechRecognitionResult, "speechRecognitionResult cannot be null");
        if (speechRecognitionResult.getProperties().getProperty("AccuracyScore").isEmpty() && speechRecognitionResult.getProperties().getProperty("ContentAssessment_GrammarScore").isEmpty()) {
            return null;
        }
        return new PronunciationAssessmentResult(speechRecognitionResult.getProperties());
    }

    public Double getAccuracyScore() {
        return this.accuracyScore;
    }

    public Double getPronunciationScore() {
        return this.pronunciationScore;
    }

    public Double getCompletenessScore() {
        return this.completenessScore;
    }

    public Double getFluencyScore() {
        return this.fluencyScore;
    }

    public Double getProsodyScore() {
        return this.prosodyScore >= 0.0 ? Double.valueOf(this.prosodyScore) : null;
    }

    public ContentAssessmentResult getContentAssessmentResult() {
        return this.contentAssessmentResult;
    }

    public List<WordLevelTimingResult> getWords() {
        return this.words;
    }

    private PronunciationAssessmentResult(PropertyCollection propertyCollection) {
        String string;
        this.accuracyScore = Double.parseDouble(propertyCollection.getProperty("AccuracyScore", "-1"));
        this.pronunciationScore = Double.parseDouble(propertyCollection.getProperty("PronScore", "-1"));
        this.completenessScore = Double.parseDouble(propertyCollection.getProperty("CompletenessScore", "-1"));
        this.fluencyScore = Double.parseDouble(propertyCollection.getProperty("FluencyScore", "-1"));
        this.prosodyScore = Double.parseDouble(propertyCollection.getProperty("ProsodyScore", "-1"));
        if (!propertyCollection.getProperty("ContentAssessment_GrammarScore").isEmpty()) {
            this.contentAssessmentResult = new ContentAssessmentResult(propertyCollection);
        }
        if ((string = propertyCollection.getProperty(PropertyId.SpeechServiceResponse_JsonResult)) != null && !string.isEmpty()) {
            this.words = new ArrayList<WordLevelTimingResult>();
            try {
                JSONArray jSONArray = new JSONObject(string).getJSONArray("NBest").getJSONObject(0).getJSONArray("Words");
                for (int i = 0; i < jSONArray.length(); ++i) {
                    WordLevelTimingResult wordLevelTimingResult = new WordLevelTimingResult(jSONArray.getJSONObject(i));
                    this.words.add(wordLevelTimingResult);
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }
}

