/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.PhonemeLevelTimingResult;
import com.microsoft.cognitiveservices.speech.SyllableLevelTimingResult;
import com.microsoft.cognitiveservices.speech.TimingResult;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public final class WordLevelTimingResult
extends TimingResult {
    private String word;
    private double accuracyScore;
    private String errorType;
    private List<PhonemeLevelTimingResult> phonemes;
    private List<SyllableLevelTimingResult> syllables;

    WordLevelTimingResult(JSONObject jSONObject) {
        super(jSONObject);
        TimingResult timingResult;
        int n;
        JSONArray jSONArray;
        this.word = jSONObject.optString("Word");
        JSONObject jSONObject2 = jSONObject.optJSONObject("PronunciationAssessment");
        if (jSONObject2 != null) {
            this.accuracyScore = jSONObject2.optDouble("AccuracyScore");
            this.errorType = jSONObject2.optString("ErrorType");
        }
        if ((jSONArray = jSONObject.optJSONArray("Phonemes")) != null) {
            this.phonemes = new ArrayList<PhonemeLevelTimingResult>();
            for (n = 0; n < jSONArray.length(); ++n) {
                timingResult = new PhonemeLevelTimingResult(jSONArray.optJSONObject(n));
                this.phonemes.add((PhonemeLevelTimingResult)timingResult);
            }
        }
        if ((jSONArray = jSONObject.optJSONArray("Syllables")) != null) {
            this.syllables = new ArrayList<SyllableLevelTimingResult>();
            for (n = 0; n < jSONArray.length(); ++n) {
                timingResult = new SyllableLevelTimingResult(jSONArray.optJSONObject(n));
                this.syllables.add((SyllableLevelTimingResult)timingResult);
            }
        }
    }

    public String getWord() {
        return this.word;
    }

    public double getAccuracyScore() {
        return this.accuracyScore;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public List<PhonemeLevelTimingResult> getPhonemes() {
        return this.phonemes;
    }

    public List<SyllableLevelTimingResult> getSyllables() {
        return this.syllables;
    }
}

