/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.audio;

import android.content.Context;
import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.audio.MicrophoneArrayGeometry;
import com.microsoft.cognitiveservices.speech.audio.MicrophoneArrayType;
import com.microsoft.cognitiveservices.speech.audio.MicrophoneCoordinates;
import com.microsoft.cognitiveservices.speech.audio.PresetMicrophoneArrayGeometry;
import com.microsoft.cognitiveservices.speech.audio.SpeakerReferenceChannel;
import com.microsoft.cognitiveservices.speech.util.ContextHolder;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public class AudioProcessingOptions
implements AutoCloseable {
    private SafeHandle audioProcessingOptionsHandle = null;

    public static AudioProcessingOptions create(int n) {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(AudioProcessingOptions.create(intRef, n));
        return new AudioProcessingOptions(intRef);
    }

    public static AudioProcessingOptions create(int n, PresetMicrophoneArrayGeometry presetMicrophoneArrayGeometry) {
        return AudioProcessingOptions.create(n, presetMicrophoneArrayGeometry, SpeakerReferenceChannel.None);
    }

    public static AudioProcessingOptions create(int n, PresetMicrophoneArrayGeometry presetMicrophoneArrayGeometry, SpeakerReferenceChannel speakerReferenceChannel) {
        Contracts.throwIfNull((Object)presetMicrophoneArrayGeometry, "microphoneArrayGeometry");
        Contracts.throwIfNull((Object)speakerReferenceChannel, "speakerReferenceChannel");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(AudioProcessingOptions.createFromPresetMicrophoneArrayGeometry(intRef, n, presetMicrophoneArrayGeometry.ordinal(), speakerReferenceChannel.ordinal()));
        return new AudioProcessingOptions(intRef);
    }

    public static AudioProcessingOptions create(int n, MicrophoneArrayGeometry microphoneArrayGeometry) {
        return AudioProcessingOptions.create(n, microphoneArrayGeometry, SpeakerReferenceChannel.None);
    }

    public static AudioProcessingOptions create(int n, MicrophoneArrayGeometry microphoneArrayGeometry, SpeakerReferenceChannel speakerReferenceChannel) {
        Contracts.throwIfNull(microphoneArrayGeometry, "microphoneArrayGeometry");
        Contracts.throwIfNull((Object)speakerReferenceChannel, "speakerReferenceChannel");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(AudioProcessingOptions.createFromMicrophoneArrayGeometry(intRef, n, microphoneArrayGeometry, speakerReferenceChannel.ordinal()));
        return new AudioProcessingOptions(intRef);
    }

    public int getAudioProcessingFlags() {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getAudioProcessingFlags(this.audioProcessingOptionsHandle, intRef));
        return (int)intRef.getValue();
    }

    public PresetMicrophoneArrayGeometry getPresetMicrophoneArrayGeometry() {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getPresetMicrophoneArrayGeometry(this.audioProcessingOptionsHandle, intRef));
        return PresetMicrophoneArrayGeometry.values()[(int)intRef.getValue()];
    }

    public MicrophoneArrayType getMicrophoneArrayType() {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getMicrophoneArrayType(this.audioProcessingOptionsHandle, intRef));
        return MicrophoneArrayType.values()[(int)intRef.getValue()];
    }

    public int getBeamformingStartAngle() {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getBeamformingStartAngle(this.audioProcessingOptionsHandle, intRef));
        return (int)intRef.getValue();
    }

    public int getBeamformingEndAngle() {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getBeamformingEndAngle(this.audioProcessingOptionsHandle, intRef));
        return (int)intRef.getValue();
    }

    public MicrophoneCoordinates[] getMicrophoneCoordinates() {
        IntRef intRef = new IntRef(0L);
        MicrophoneCoordinates[] microphoneCoordinatesArray = this.getMicrophoneCoordinates(this.audioProcessingOptionsHandle, intRef);
        Contracts.throwIfFail(intRef.getValue());
        return microphoneCoordinatesArray;
    }

    public SpeakerReferenceChannel getSpeakerReferenceChannel() {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getSpeakerReferenceChannel(this.audioProcessingOptionsHandle, intRef));
        return SpeakerReferenceChannel.values()[(int)intRef.getValue()];
    }

    @Override
    public void close() {
        if (this.audioProcessingOptionsHandle != null) {
            this.audioProcessingOptionsHandle.close();
            this.audioProcessingOptionsHandle = null;
        }
    }

    AudioProcessingOptions(IntRef intRef) {
        Contracts.throwIfNull(intRef, "audioProcessingOptions");
        this.audioProcessingOptionsHandle = new SafeHandle(intRef.getValue(), SafeHandleType.AudioProcessingOptions);
        Contracts.throwIfFail(this.extractAssets(this.audioProcessingOptionsHandle, ContextHolder.getInstance().getContext()));
    }

    public SafeHandle getImpl() {
        return this.audioProcessingOptionsHandle;
    }

    private static final native long create(IntRef var0, int var1);

    private static final native long createFromPresetMicrophoneArrayGeometry(IntRef var0, int var1, int var2, int var3);

    private static final native long createFromMicrophoneArrayGeometry(IntRef var0, int var1, MicrophoneArrayGeometry var2, int var3);

    private final native long extractAssets(SafeHandle var1, Context var2);

    private final native long getAudioProcessingFlags(SafeHandle var1, IntRef var2);

    private final native long getPresetMicrophoneArrayGeometry(SafeHandle var1, IntRef var2);

    private final native long getMicrophoneArrayType(SafeHandle var1, IntRef var2);

    private final native long getBeamformingStartAngle(SafeHandle var1, IntRef var2);

    private final native long getBeamformingEndAngle(SafeHandle var1, IntRef var2);

    private final native MicrophoneCoordinates[] getMicrophoneCoordinates(SafeHandle var1, IntRef var2);

    private final native long getSpeakerReferenceChannel(SafeHandle var1, IntRef var2);

    static {
        try {
            Class.forName(SpeechConfig.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
    }
}

