/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.util;

import android.net.ConnectivityManager;
import android.os.Build;
import com.microsoft.cognitiveservices.speech.util.ConnectivityCallback;
import com.microsoft.cognitiveservices.speech.util.Request;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;

public class HttpClient {
    private static final int MAX_HTTP_THREADS = 2;
    private final ExecutorService m_executor;
    private ConnectivityCallback m_callback;
    private ConnectivityManager m_connectivityManager;

    public HttpClient() {
        String string = System.getProperty("java.io.tmpdir");
        this.setCacheFilePath(string);
        this.m_executor = this.createExecutor();
        this.createClientInstance();
    }

    protected ExecutorService createExecutor() {
        return Executors.newFixedThreadPool(2);
    }

    protected boolean hasConnectivityManager() {
        return Build.VERSION.SDK_INT >= 24;
    }

    public void finalize() {
        if (this.m_callback != null) {
            this.m_connectivityManager.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)this.m_callback);
            this.m_callback = null;
        }
        this.deleteClientInstance();
        this.m_executor.shutdown();
    }

    public URL newUrl(String string) throws MalformedURLException {
        return new URL(string);
    }

    public native void createClientInstance();

    public native void deleteClientInstance();

    public native void setCacheFilePath(String var1);

    public native void onCostChange(boolean var1);

    public native void onPowerChange(boolean var1, boolean var2);

    public native void setDeviceInfo(String var1, String var2, String var3);

    public native void setSystemInfo(String var1, String var2, String var3, String var4, String var5, String var6);

    public native void dispatchCallback(String var1, int var2, Object[] var3, byte[] var4);

    public FutureTask<Boolean> createTask(String string, String string2, byte[] byArray, String string3, int[] nArray, byte[] byArray2) {
        try {
            Request request = new Request(this, string, string2, byArray, string3, nArray, byArray2);
            return new FutureShim(request);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void executeTask(FutureTask<Boolean> futureTask) {
        this.m_executor.execute(futureTask);
    }

    static class FutureShim
    extends FutureTask<Boolean> {
        FutureShim(Request request) {
            super(request, true);
        }

        @Override
        public boolean cancel(boolean bl) {
            return super.cancel(bl);
        }
    }
}

