/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.translation;

import com.microsoft.cognitiveservices.speech.RecognitionEventArgs;
import com.microsoft.cognitiveservices.speech.translation.TranslationRecognitionResult;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;

public class TranslationRecognitionEventArgs
extends RecognitionEventArgs {
    private TranslationRecognitionResult result;

    TranslationRecognitionEventArgs(long l) {
        super(l);
        this.storeEventData(false);
    }

    TranslationRecognitionEventArgs(long l, boolean bl) {
        super(l);
        this.storeEventData(bl);
    }

    public final TranslationRecognitionResult getResult() {
        return this.result;
    }

    @Override
    public String toString() {
        String string = "TranslationRecognitionResult " + super.toString();
        for (String string2 : this.result.getTranslations().keySet()) {
            string = string + "    Translation in " + string2 + ": <" + this.result.getTranslations().get(string2) + ">.\n";
        }
        return string;
    }

    private void storeEventData(boolean bl) {
        Contracts.throwIfNull(this.eventHandle, "eventHandle");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getRecognitionResult(this.eventHandle, intRef));
        this.result = new TranslationRecognitionResult(intRef.getValue());
        Contracts.throwIfNull(this.getSessionId(), "SessionId");
        if (bl) {
            super.close();
        }
    }
}

