/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.translation;

import com.microsoft.cognitiveservices.speech.SessionEventArgs;
import com.microsoft.cognitiveservices.speech.translation.TranslationSynthesisResult;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;

public final class TranslationSynthesisEventArgs
extends SessionEventArgs {
    private TranslationSynthesisResult result;

    TranslationSynthesisEventArgs(long l) {
        super(l);
        this.storeEventData(false);
    }

    TranslationSynthesisEventArgs(long l, boolean bl) {
        super(l);
        this.storeEventData(bl);
    }

    public final TranslationSynthesisResult getResult() {
        return this.result;
    }

    @Override
    public String toString() {
        return "SessionId:" + this.getSessionId() + " Result:" + this.result.toString() + ".";
    }

    private void storeEventData(boolean bl) {
        Contracts.throwIfNull(this.eventHandle, "eventHandle");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getSynthesisResult(this.eventHandle, intRef));
        this.result = new TranslationSynthesisResult(intRef.getValue());
        Contracts.throwIfNull(this.getSessionId(), "SessionId");
        if (bl) {
            super.close();
        }
    }

    private final native long getSynthesisResult(SafeHandle var1, IntRef var2);
}

