/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.translation;

import com.microsoft.cognitiveservices.speech.ResultReason;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public final class TranslationSynthesisResult {
    private byte[] audioData;
    private SafeHandle resultHandle;
    private ResultReason reason;

    TranslationSynthesisResult(long l) {
        Contracts.throwIfNull(l, "result");
        this.resultHandle = new SafeHandle(l, SafeHandleType.RecognitionResult);
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getResultReason(this.resultHandle, intRef));
        this.reason = ResultReason.values()[(int)intRef.getValue()];
        IntRef intRef2 = new IntRef(0L);
        this.audioData = this.getAudio(this.resultHandle, intRef2);
        Contracts.throwIfFail(intRef2.getValue());
    }

    public void close() {
        if (this.resultHandle != null) {
            this.resultHandle.close();
        }
        this.resultHandle = null;
    }

    public ResultReason getReason() {
        return this.reason;
    }

    public byte[] getAudio() {
        return this.audioData;
    }

    public String toString() {
        return "TranslationSynthesisResult Reason:" + (Object)((Object)this.reason) + " Audio.length:" + this.audioData.length + ".";
    }

    private final native long getResultReason(SafeHandle var1, IntRef var2);

    private final native byte[] getAudio(SafeHandle var1, IntRef var2);
}

