/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.azure.core.credential.KeyCredential;
import com.azure.core.credential.TokenCredential;
import com.microsoft.cognitiveservices.speech.OutputFormat;
import com.microsoft.cognitiveservices.speech.ProfanityOption;
import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.ServicePropertyChannel;
import com.microsoft.cognitiveservices.speech.SpeechSynthesisOutputFormat;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import java.lang.reflect.Method;
import java.net.URI;

public class SpeechConfig
implements AutoCloseable {
    public static Class<?> speechConfigClass;
    private TokenCredential tokenCredential = null;
    private SafeHandle speechConfigHandle = null;
    private PropertyCollection propertyHandle = null;
    private boolean disposed = false;

    protected SpeechConfig(long l) {
        Contracts.throwIfNull(l, "handleValue");
        this.speechConfigHandle = new SafeHandle(l, SafeHandleType.SpeechConfig);
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBag(this.speechConfigHandle, intRef));
        this.propertyHandle = new PropertyCollection(intRef);
        this.propertyHandle.setProperty("AZAC-SDK-PROGRAMMING-LANGUAGE", "Java");
    }

    protected SpeechConfig(long l, TokenCredential tokenCredential) {
        this(l);
        this.tokenCredential = tokenCredential;
    }

    public static SpeechConfig fromSubscription(String string, String string2) {
        Contracts.throwIfIllegalSubscriptionKey(string, "subscriptionKey");
        Contracts.throwIfNullOrWhitespace(string2, "region");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(SpeechConfig.fromSubscription(intRef, string, string2));
        return new SpeechConfig(intRef.getValue());
    }

    public static SpeechConfig fromAuthorizationToken(String string, String string2) {
        Contracts.throwIfNullOrWhitespace(string, "authorizationToken");
        Contracts.throwIfNullOrWhitespace(string2, "region");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(SpeechConfig.fromAuthorizationToken(intRef, string, string2));
        return new SpeechConfig(intRef.getValue());
    }

    public static SpeechConfig fromEndpoint(URI uRI, String string) {
        Contracts.throwIfNull(uRI, "endpoint");
        if (string == null) {
            throw new NullPointerException("subscriptionKey");
        }
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(SpeechConfig.fromEndpoint(intRef, uRI.toString(), string));
        return new SpeechConfig(intRef.getValue());
    }

    public static SpeechConfig fromEndpoint(URI uRI, KeyCredential keyCredential) {
        Contracts.throwIfNull(uRI, "endpoint");
        Contracts.throwIfNull(keyCredential, "keyCredential");
        IntRef intRef = new IntRef(0L);
        String string = keyCredential.getKey();
        Contracts.throwIfFail(SpeechConfig.fromEndpoint(intRef, uRI.toString(), string));
        return new SpeechConfig(intRef.getValue());
    }

    public static SpeechConfig fromEndpoint(URI uRI) {
        Contracts.throwIfNull(uRI, "endpoint");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(SpeechConfig.fromEndpoint(intRef, uRI.toString(), null));
        return new SpeechConfig(intRef.getValue());
    }

    public static SpeechConfig fromEndpoint(URI uRI, TokenCredential tokenCredential) {
        Contracts.throwIfNull(uRI, "endpoint");
        Contracts.throwIfNull(tokenCredential, "credential");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(SpeechConfig.fromEndpoint(intRef, uRI.toString(), null));
        return new SpeechConfig(intRef.getValue(), tokenCredential);
    }

    public static SpeechConfig fromHost(URI uRI, String string) {
        Contracts.throwIfNull(uRI, "host");
        if (string == null) {
            throw new NullPointerException("subscriptionKey");
        }
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(SpeechConfig.fromHost(intRef, uRI.toString(), string));
        return new SpeechConfig(intRef.getValue());
    }

    public static SpeechConfig fromHost(URI uRI) {
        Contracts.throwIfNull(uRI, "host");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(SpeechConfig.fromHost(intRef, uRI.toString(), null));
        return new SpeechConfig(intRef.getValue());
    }

    public void setAuthorizationToken(String string) {
        Contracts.throwIfNullOrWhitespace(string, "value");
        this.propertyHandle.setProperty(PropertyId.SpeechServiceAuthorization_Token, string);
    }

    public String getAuthorizationToken() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceAuthorization_Token);
    }

    public void setSpeechRecognitionLanguage(String string) {
        Contracts.throwIfNullOrWhitespace(string, "value");
        this.propertyHandle.setProperty(PropertyId.SpeechServiceConnection_RecoLanguage, string);
    }

    public String getSpeechRecognitionLanguage() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceConnection_RecoLanguage);
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        String string = "false";
        if (outputFormat == OutputFormat.Detailed) {
            string = "true";
        }
        this.propertyHandle.setProperty(PropertyId.SpeechServiceResponse_RequestDetailedResultTrueFalse, string);
    }

    public OutputFormat getOutputFormat() {
        String string = this.propertyHandle.getProperty(PropertyId.SpeechServiceResponse_RequestDetailedResultTrueFalse);
        return string.equals("true") ? OutputFormat.Detailed : OutputFormat.Simple;
    }

    public void setEndpointId(String string) {
        Contracts.throwIfNullOrWhitespace(string, "value");
        this.propertyHandle.setProperty(PropertyId.SpeechServiceConnection_EndpointId, string);
    }

    public String getEndpointId() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceConnection_EndpointId);
    }

    public void setSpeechSynthesisLanguage(String string) {
        Contracts.throwIfNullOrWhitespace(string, "value");
        this.propertyHandle.setProperty(PropertyId.SpeechServiceConnection_SynthLanguage, string);
    }

    public String getSpeechSynthesisLanguage() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceConnection_SynthLanguage);
    }

    public void setSpeechSynthesisVoiceName(String string) {
        Contracts.throwIfNullOrWhitespace(string, "value");
        this.propertyHandle.setProperty(PropertyId.SpeechServiceConnection_SynthVoice, string);
    }

    public String getSpeechSynthesisVoiceName() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceConnection_SynthVoice);
    }

    public void setSpeechSynthesisOutputFormat(SpeechSynthesisOutputFormat speechSynthesisOutputFormat) {
        Contracts.throwIfFail(this.setAudioOutputFormat(this.speechConfigHandle, speechSynthesisOutputFormat.getValue()));
    }

    public String getSpeechSynthesisOutputFormat() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceConnection_SynthOutputFormat);
    }

    public void setProxy(String string, int n, String string2, String string3) {
        Contracts.throwIfNullOrWhitespace(string, "proxyHostName");
        Contracts.throwIfNull(string2, "proxyUserName");
        Contracts.throwIfNull(string3, "proxyPassword");
        if (n <= 0) {
            throw new IllegalArgumentException("invalid proxy port");
        }
        this.propertyHandle.setProperty(PropertyId.SpeechServiceConnection_ProxyHostName, string);
        this.propertyHandle.setProperty(PropertyId.SpeechServiceConnection_ProxyPort, Integer.toString(n));
        if (string2 != "") {
            this.propertyHandle.setProperty(PropertyId.SpeechServiceConnection_ProxyUserName, string2);
        }
        if (string3 != "") {
            this.propertyHandle.setProperty(PropertyId.SpeechServiceConnection_ProxyPassword, string3);
        }
    }

    public void setProperty(String string, String string2) {
        Contracts.throwIfNullOrWhitespace(string, "name");
        this.propertyHandle.setProperty(string, string2);
    }

    public void setProperty(PropertyId propertyId, String string) {
        this.propertyHandle.setProperty(propertyId, string);
    }

    public String getProperty(String string) {
        return this.propertyHandle.getProperty(string);
    }

    public String getProperty(PropertyId propertyId) {
        return this.propertyHandle.getProperty(propertyId);
    }

    public void setServiceProperty(String string, String string2, ServicePropertyChannel servicePropertyChannel) {
        Contracts.throwIfNullOrWhitespace(string, "name");
        Contracts.throwIfNullOrWhitespace(string2, "value");
        Contracts.throwIfFail(this.setServiceProperty(this.speechConfigHandle, string, string2, servicePropertyChannel.getValue()));
    }

    public void setProfanity(ProfanityOption profanityOption) {
        Contracts.throwIfFail(this.setProfanity(this.speechConfigHandle, profanityOption.getValue()));
    }

    public void enableAudioLogging() {
        this.propertyHandle.setProperty(PropertyId.SpeechServiceConnection_EnableAudioLogging, "true");
    }

    public void requestWordLevelTimestamps() {
        this.propertyHandle.setProperty(PropertyId.SpeechServiceResponse_RequestWordLevelTimestamps, "true");
    }

    public void enableDictation() {
        this.propertyHandle.setProperty(PropertyId.SpeechServiceConnection_RecoMode, "DICTATION");
    }

    @Override
    public void close() {
        if (this.disposed) {
            return;
        }
        if (this.propertyHandle != null) {
            this.propertyHandle.close();
            this.propertyHandle = null;
        }
        if (this.speechConfigHandle != null) {
            this.speechConfigHandle.close();
            this.speechConfigHandle = null;
        }
        this.disposed = true;
    }

    public SafeHandle getImpl() {
        return this.speechConfigHandle;
    }

    public TokenCredential getTokenCredential() {
        return this.tokenCredential;
    }

    private static final native long fromSubscription(IntRef var0, String var1, String var2);

    private static final native long fromAuthorizationToken(IntRef var0, String var1, String var2);

    private static final native long fromEndpoint(IntRef var0, String var1, String var2);

    private static final native long fromHost(IntRef var0, String var1, String var2);

    private final native long getPropertyBag(SafeHandle var1, IntRef var2);

    private final native long setProfanity(SafeHandle var1, int var2);

    private final native long setServiceProperty(SafeHandle var1, String var2, String var3, int var4);

    private final native long setAudioOutputFormat(SafeHandle var1, int var2);

    private static final native void setTempDirectory(String var0);

    static {
        block7: {
            speechConfigClass = null;
            boolean bl = System.getProperty("java.specification.vendor").equals("The Android Project");
            try {
                Class<?> clazz = Class.forName("com.microsoft.cognitiveservices.speech.NativeLibraryLoader");
                if (clazz != null) {
                    try {
                        Method method = clazz.getMethod("loadNativeBinding", new Class[0]);
                        method.invoke(null, new Object[0]);
                        break block7;
                    }
                    catch (Throwable throwable) {
                        if (!bl) {
                            throw throwable;
                        }
                        break block7;
                    }
                }
                throw new NullPointerException("no native loader available");
            }
            catch (Throwable throwable) {
                if (!bl) {
                    String string = String.format("Error with native library loader: %s: %s", throwable.getClass().getCanonicalName(), throwable.getMessage());
                    System.err.println(string);
                    throw new UnsupportedOperationException(string);
                }
                System.loadLibrary("Microsoft.CognitiveServices.Speech.java.bindings");
                System.loadLibrary("Microsoft.CognitiveServices.Speech.core");
            }
        }
        SpeechConfig.setTempDirectory(System.getProperty("java.io.tmpdir"));
        speechConfigClass = SpeechConfig.class;
    }
}

