/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.dialog;

import com.microsoft.cognitiveservices.speech.KeywordRecognitionModel;
import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.RecognitionEventArgs;
import com.microsoft.cognitiveservices.speech.SessionEventArgs;
import com.microsoft.cognitiveservices.speech.SpeechRecognitionCanceledEventArgs;
import com.microsoft.cognitiveservices.speech.SpeechRecognitionEventArgs;
import com.microsoft.cognitiveservices.speech.SpeechRecognitionResult;
import com.microsoft.cognitiveservices.speech.audio.AudioConfig;
import com.microsoft.cognitiveservices.speech.dialog.ActivityReceivedEventArgs;
import com.microsoft.cognitiveservices.speech.dialog.DialogServiceConfig;
import com.microsoft.cognitiveservices.speech.dialog.TurnStatusReceivedEventArgs;
import com.microsoft.cognitiveservices.speech.util.AsyncThreadService;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.EventHandlerImpl;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import com.microsoft.cognitiveservices.speech.util.StringRef;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

public class DialogServiceConnector
implements AutoCloseable {
    static Class<?> dialogServiceConnector = null;
    private AtomicInteger eventCounter = new AtomicInteger(0);
    private AudioConfig audioInputKeepAlive = null;
    private PropertyCollection propertyHandle;
    public EventHandlerImpl<SpeechRecognitionEventArgs> recognizing = new EventHandlerImpl(this.eventCounter);
    public EventHandlerImpl<SpeechRecognitionEventArgs> recognized = new EventHandlerImpl(this.eventCounter);
    public EventHandlerImpl<SessionEventArgs> sessionStarted = new EventHandlerImpl(this.eventCounter);
    public EventHandlerImpl<SessionEventArgs> sessionStopped = new EventHandlerImpl(this.eventCounter);
    public EventHandlerImpl<RecognitionEventArgs> speechStartDetected = new EventHandlerImpl(this.eventCounter);
    public EventHandlerImpl<RecognitionEventArgs> speechEndDetected = new EventHandlerImpl(this.eventCounter);
    public EventHandlerImpl<SpeechRecognitionCanceledEventArgs> canceled = new EventHandlerImpl(this.eventCounter);
    public EventHandlerImpl<ActivityReceivedEventArgs> activityReceived = new EventHandlerImpl(this.eventCounter);
    public EventHandlerImpl<TurnStatusReceivedEventArgs> turnStatusReceived = new EventHandlerImpl(this.eventCounter);
    static Set<DialogServiceConnector> dialogServiceConnectorObjects;
    private SafeHandle dialogServiceConnectorHandle = null;
    private boolean disposed = false;

    public DialogServiceConnector(DialogServiceConfig dialogServiceConfig) {
        this(dialogServiceConfig, AudioConfig.fromDefaultMicrophoneInput());
    }

    public DialogServiceConnector(DialogServiceConfig dialogServiceConfig, AudioConfig audioConfig) {
        Contracts.throwIfNull(dialogServiceConfig, "config");
        if (audioConfig == null) {
            this.dialogServiceConnectorHandle = new SafeHandle(0L, SafeHandleType.DialogServiceConnector);
            Contracts.throwIfFail(DialogServiceConnector.createDialogServiceConnectorFomConfig(this.dialogServiceConnectorHandle, dialogServiceConfig.getImpl(), null));
        } else {
            this.dialogServiceConnectorHandle = new SafeHandle(0L, SafeHandleType.DialogServiceConnector);
            Contracts.throwIfFail(DialogServiceConnector.createDialogServiceConnectorFomConfig(this.dialogServiceConnectorHandle, dialogServiceConfig.getImpl(), audioConfig.getImpl()));
        }
        this.audioInputKeepAlive = audioConfig;
        this.initialize();
    }

    public void setAuthorizationToken(String string) {
        Contracts.throwIfNullOrWhitespace(string, "token");
        this.propertyHandle.setProperty(PropertyId.SpeechServiceAuthorization_Token, string);
    }

    public String getAuthorizationToken() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceAuthorization_Token);
    }

    public PropertyCollection getProperties() {
        return this.propertyHandle;
    }

    public Future<Void> connectAsync() {
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Contracts.throwIfFail(DialogServiceConnector.this.connect(DialogServiceConnector.this.dialogServiceConnectorHandle));
                return null;
            }
        });
    }

    public Future<Void> disconnectAsync() {
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Contracts.throwIfFail(DialogServiceConnector.this.disconnect(DialogServiceConnector.this.dialogServiceConnectorHandle));
                return null;
            }
        });
    }

    public Future<String> sendActivityAsync(final String string) {
        Contracts.throwIfNull(string, "activity");
        return AsyncThreadService.submit(new Callable<String>(){

            @Override
            public String call() {
                StringRef stringRef = new StringRef("");
                Contracts.throwIfFail(DialogServiceConnector.this.sendActivity(DialogServiceConnector.this.dialogServiceConnectorHandle, stringRef, string));
                return stringRef.getValue();
            }
        });
    }

    public void setSpeechActivityTemplate(String string) {
        Contracts.throwIfNullOrWhitespace(string, "template");
        this.propertyHandle.setProperty(PropertyId.Conversation_Speech_Activity_Template, string);
    }

    public Future<SpeechRecognitionResult> listenOnceAsync() {
        return AsyncThreadService.submit(new Callable<SpeechRecognitionResult>(){

            @Override
            public SpeechRecognitionResult call() {
                IntRef intRef = new IntRef(0L);
                Contracts.throwIfFail(DialogServiceConnector.this.listenOnce(DialogServiceConnector.this.dialogServiceConnectorHandle, intRef));
                return new DialogSpeechRecognitionResult(intRef.getValue());
            }
        });
    }

    public Future<Void> stopListeningAsync() {
        final DialogServiceConnector dialogServiceConnector = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Contracts.throwIfFail(dialogServiceConnector.stopListening(dialogServiceConnector.dialogServiceConnectorHandle));
                return null;
            }
        });
    }

    public Future<Void> startKeywordRecognitionAsync(final KeywordRecognitionModel keywordRecognitionModel) {
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Contracts.throwIfFail(DialogServiceConnector.this.startKeywordRecognition(DialogServiceConnector.this.dialogServiceConnectorHandle, keywordRecognitionModel.getImpl()));
                return null;
            }
        });
    }

    public Future<Void> stopKeywordRecognitionAsync() {
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Contracts.throwIfFail(DialogServiceConnector.this.stopKeywordRecognition(DialogServiceConnector.this.dialogServiceConnectorHandle));
                return null;
            }
        });
    }

    private void initialize() {
        final DialogServiceConnector dialogServiceConnector = this;
        AsyncThreadService.initialize();
        this.recognizing.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                dialogServiceConnectorObjects.add(dialogServiceConnector);
                Contracts.throwIfFail(DialogServiceConnector.this.recognizingSetCallback(dialogServiceConnector.dialogServiceConnectorHandle.getValue()));
            }
        });
        this.recognized.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                dialogServiceConnectorObjects.add(dialogServiceConnector);
                Contracts.throwIfFail(DialogServiceConnector.this.recognizedSetCallback(dialogServiceConnector.dialogServiceConnectorHandle.getValue()));
            }
        });
        this.sessionStarted.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                dialogServiceConnectorObjects.add(dialogServiceConnector);
                Contracts.throwIfFail(DialogServiceConnector.this.sessionStartedSetCallback(dialogServiceConnector.dialogServiceConnectorHandle.getValue()));
            }
        });
        this.sessionStopped.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                dialogServiceConnectorObjects.add(dialogServiceConnector);
                Contracts.throwIfFail(DialogServiceConnector.this.sessionStoppedSetCallback(dialogServiceConnector.dialogServiceConnectorHandle.getValue()));
            }
        });
        this.speechStartDetected.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                dialogServiceConnectorObjects.add(dialogServiceConnector);
                Contracts.throwIfFail(DialogServiceConnector.this.speechStartDetectedSetCallback(dialogServiceConnector.dialogServiceConnectorHandle.getValue()));
            }
        });
        this.speechEndDetected.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                dialogServiceConnectorObjects.add(dialogServiceConnector);
                Contracts.throwIfFail(DialogServiceConnector.this.speechEndDetectedSetCallback(dialogServiceConnector.dialogServiceConnectorHandle.getValue()));
            }
        });
        this.canceled.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                dialogServiceConnectorObjects.add(dialogServiceConnector);
                Contracts.throwIfFail(DialogServiceConnector.this.canceledSetCallback(dialogServiceConnector.dialogServiceConnectorHandle.getValue()));
            }
        });
        this.activityReceived.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                dialogServiceConnectorObjects.add(dialogServiceConnector);
                Contracts.throwIfFail(DialogServiceConnector.this.activityReceivedSetCallback(dialogServiceConnector.dialogServiceConnectorHandle.getValue()));
            }
        });
        this.turnStatusReceived.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                dialogServiceConnectorObjects.add(dialogServiceConnector);
                Contracts.throwIfFail(DialogServiceConnector.this.turnStatusReceivedSetCallback(dialogServiceConnector.dialogServiceConnectorHandle.getValue()));
            }
        });
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBagFromDialogServiceConnectorHandle(dialogServiceConnector.dialogServiceConnectorHandle, intRef));
        this.propertyHandle = new PropertyCollection(intRef);
    }

    private void recognizingEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "connector");
            if (this.disposed) {
                return;
            }
            SpeechRecognitionEventArgs speechRecognitionEventArgs = new SpeechRecognitionEventArgs(l, true);
            EventHandlerImpl<SpeechRecognitionEventArgs> eventHandlerImpl = this.recognizing;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, speechRecognitionEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void recognizedEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "connector");
            if (this.disposed) {
                return;
            }
            SpeechRecognitionEventArgs speechRecognitionEventArgs = new SpeechRecognitionEventArgs(l, true);
            EventHandlerImpl<SpeechRecognitionEventArgs> eventHandlerImpl = this.recognized;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, speechRecognitionEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sessionStartedEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "connector");
            if (this.disposed) {
                return;
            }
            SessionEventArgs sessionEventArgs = new SessionEventArgs(l, true);
            EventHandlerImpl<SessionEventArgs> eventHandlerImpl = this.sessionStarted;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, sessionEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sessionStoppedEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "connector");
            if (this.disposed) {
                return;
            }
            SessionEventArgs sessionEventArgs = new SessionEventArgs(l, true);
            EventHandlerImpl<SessionEventArgs> eventHandlerImpl = this.sessionStopped;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, sessionEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void speechStartDetectedEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "connector");
            if (this.disposed) {
                return;
            }
            RecognitionEventArgs recognitionEventArgs = new RecognitionEventArgs(l, true);
            EventHandlerImpl<RecognitionEventArgs> eventHandlerImpl = this.speechStartDetected;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, recognitionEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void speechEndDetectedEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "connector");
            if (this.disposed) {
                return;
            }
            RecognitionEventArgs recognitionEventArgs = new RecognitionEventArgs(l, true);
            EventHandlerImpl<RecognitionEventArgs> eventHandlerImpl = this.speechEndDetected;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, recognitionEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void canceledEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "connector");
            if (this.disposed) {
                return;
            }
            SpeechRecognitionCanceledEventArgs speechRecognitionCanceledEventArgs = new SpeechRecognitionCanceledEventArgs(l, true);
            EventHandlerImpl<SpeechRecognitionCanceledEventArgs> eventHandlerImpl = this.canceled;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, speechRecognitionCanceledEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void activityReceivedEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "connector");
            if (this.disposed) {
                return;
            }
            ActivityReceivedEventArgs activityReceivedEventArgs = new ActivityReceivedEventArgs(l);
            EventHandlerImpl<ActivityReceivedEventArgs> eventHandlerImpl = this.activityReceived;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, activityReceivedEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void turnStatusReceivedEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "connector");
            if (this.disposed) {
                return;
            }
            TurnStatusReceivedEventArgs turnStatusReceivedEventArgs = new TurnStatusReceivedEventArgs(l);
            EventHandlerImpl<TurnStatusReceivedEventArgs> eventHandlerImpl = this.turnStatusReceived;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, turnStatusReceivedEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SafeHandle getImpl() {
        return this.dialogServiceConnectorHandle;
    }

    @Override
    public void close() {
        this.dispose(true);
    }

    private void dispose(boolean bl) {
        if (this.disposed) {
            return;
        }
        if (bl) {
            if (this.propertyHandle != null) {
                this.propertyHandle.close();
                this.propertyHandle = null;
            }
            if (this.dialogServiceConnectorHandle != null) {
                this.dialogServiceConnectorHandle.close();
                this.dialogServiceConnectorHandle = null;
            }
            this.audioInputKeepAlive = null;
            dialogServiceConnectorObjects.remove(this);
            AsyncThreadService.shutdown();
            this.disposed = true;
        }
    }

    private static final native long createDialogServiceConnectorFomConfig(SafeHandle var0, SafeHandle var1, SafeHandle var2);

    private final native long connect(SafeHandle var1);

    private final native long disconnect(SafeHandle var1);

    private final native long sendActivity(SafeHandle var1, StringRef var2, String var3);

    private final native long listenOnce(SafeHandle var1, IntRef var2);

    private final native long stopListening(SafeHandle var1);

    private final native long startKeywordRecognition(SafeHandle var1, SafeHandle var2);

    private final native long stopKeywordRecognition(SafeHandle var1);

    private final native long recognizingSetCallback(long var1);

    private final native long recognizedSetCallback(long var1);

    private final native long sessionStartedSetCallback(long var1);

    private final native long sessionStoppedSetCallback(long var1);

    private final native long speechStartDetectedSetCallback(long var1);

    private final native long speechEndDetectedSetCallback(long var1);

    private final native long canceledSetCallback(long var1);

    private final native long activityReceivedSetCallback(long var1);

    private final native long turnStatusReceivedSetCallback(long var1);

    private final native long getPropertyBagFromDialogServiceConnectorHandle(SafeHandle var1, IntRef var2);

    static {
        try {
            Class.forName(DialogServiceConfig.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
        dialogServiceConnector = DialogServiceConnector.class;
        dialogServiceConnectorObjects = Collections.synchronizedSet(new HashSet());
    }

    private class DialogSpeechRecognitionResult
    extends SpeechRecognitionResult {
        DialogSpeechRecognitionResult(long l) {
            super(l);
        }
    }
}

