/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.transcription;

import com.microsoft.cognitiveservices.speech.AutoDetectSourceLanguageConfig;
import com.microsoft.cognitiveservices.speech.OutputFormat;
import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.Recognizer;
import com.microsoft.cognitiveservices.speech.SourceLanguageConfig;
import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.audio.AudioConfig;
import com.microsoft.cognitiveservices.speech.transcription.ConversationTranscriptionCanceledEventArgs;
import com.microsoft.cognitiveservices.speech.transcription.ConversationTranscriptionEventArgs;
import com.microsoft.cognitiveservices.speech.util.AsyncThreadService;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.EventHandlerImpl;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public final class ConversationTranscriber
extends Recognizer {
    public final EventHandlerImpl<ConversationTranscriptionEventArgs> transcribing;
    public final EventHandlerImpl<ConversationTranscriptionEventArgs> transcribed;
    public final EventHandlerImpl<ConversationTranscriptionCanceledEventArgs> canceled;
    static Set<ConversationTranscriber> conversationTranscriberObjects = Collections.synchronizedSet(new HashSet());
    private PropertyCollection propertyHandle;

    public ConversationTranscriber(SpeechConfig speechConfig) {
        super(null, speechConfig.getTokenCredential());
        this.transcribing = new EventHandlerImpl(this.eventCounter);
        this.transcribed = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        Contracts.throwIfNull(speechConfig, "speechConfig");
        Contracts.throwIfNull(super.getImpl(), "recoHandle");
        Contracts.throwIfFail(this.createConversationTranscriberFromConfig(super.getImpl(), speechConfig.getImpl(), null));
        this.initialize();
    }

    public ConversationTranscriber(SpeechConfig speechConfig, AudioConfig audioConfig) {
        super(audioConfig, speechConfig.getTokenCredential());
        this.transcribing = new EventHandlerImpl(this.eventCounter);
        this.transcribed = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        Contracts.throwIfNull(speechConfig, "speechConfig");
        if (audioConfig == null) {
            Contracts.throwIfFail(this.createConversationTranscriberFromConfig(super.getImpl(), speechConfig.getImpl(), null));
        } else {
            Contracts.throwIfFail(this.createConversationTranscriberFromConfig(super.getImpl(), speechConfig.getImpl(), audioConfig.getImpl()));
        }
        this.initialize();
    }

    public ConversationTranscriber(SpeechConfig speechConfig, AutoDetectSourceLanguageConfig autoDetectSourceLanguageConfig) {
        super(null, speechConfig.getTokenCredential());
        this.transcribing = new EventHandlerImpl(this.eventCounter);
        this.transcribed = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        Contracts.throwIfNull(speechConfig, "speechConfig");
        Contracts.throwIfNull(autoDetectSourceLanguageConfig, "autoDetectSourceLangConfig");
        Contracts.throwIfFail(this.createConversationTranscriberFromAutoDetectSourceLangConfig(super.getImpl(), speechConfig.getImpl(), autoDetectSourceLanguageConfig.getImpl(), null));
        this.initialize();
    }

    public ConversationTranscriber(SpeechConfig speechConfig, AutoDetectSourceLanguageConfig autoDetectSourceLanguageConfig, AudioConfig audioConfig) {
        super(audioConfig, speechConfig.getTokenCredential());
        this.transcribing = new EventHandlerImpl(this.eventCounter);
        this.transcribed = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        Contracts.throwIfNull(speechConfig, "speechConfig");
        Contracts.throwIfNull(autoDetectSourceLanguageConfig, "autoDetectSourceLangConfig");
        if (audioConfig == null) {
            Contracts.throwIfFail(this.createConversationTranscriberFromAutoDetectSourceLangConfig(super.getImpl(), speechConfig.getImpl(), autoDetectSourceLanguageConfig.getImpl(), null));
        } else {
            Contracts.throwIfFail(this.createConversationTranscriberFromAutoDetectSourceLangConfig(super.getImpl(), speechConfig.getImpl(), autoDetectSourceLanguageConfig.getImpl(), audioConfig.getImpl()));
        }
        this.initialize();
    }

    public ConversationTranscriber(SpeechConfig speechConfig, SourceLanguageConfig sourceLanguageConfig) {
        super(null, speechConfig.getTokenCredential());
        this.transcribing = new EventHandlerImpl(this.eventCounter);
        this.transcribed = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        Contracts.throwIfNull(speechConfig, "speechConfig");
        Contracts.throwIfNull(sourceLanguageConfig, "sourceLanguageConfig");
        Contracts.throwIfFail(this.createConversationTranscriberFromSourceLangConfig(super.getImpl(), speechConfig.getImpl(), sourceLanguageConfig.getImpl(), null));
        this.initialize();
    }

    public ConversationTranscriber(SpeechConfig speechConfig, SourceLanguageConfig sourceLanguageConfig, AudioConfig audioConfig) {
        super(audioConfig, speechConfig.getTokenCredential());
        this.transcribing = new EventHandlerImpl(this.eventCounter);
        this.transcribed = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        Contracts.throwIfNull(speechConfig, "speechConfig");
        Contracts.throwIfNull(sourceLanguageConfig, "sourceLanguageConfig");
        if (audioConfig == null) {
            Contracts.throwIfFail(this.createConversationTranscriberFromSourceLangConfig(super.getImpl(), speechConfig.getImpl(), sourceLanguageConfig.getImpl(), null));
        } else {
            Contracts.throwIfFail(this.createConversationTranscriberFromSourceLangConfig(super.getImpl(), speechConfig.getImpl(), sourceLanguageConfig.getImpl(), audioConfig.getImpl()));
        }
        this.initialize();
    }

    public ConversationTranscriber(SpeechConfig speechConfig, String string) {
        super(null, speechConfig.getTokenCredential());
        this.transcribing = new EventHandlerImpl(this.eventCounter);
        this.transcribed = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        Contracts.throwIfNull(speechConfig, "speechConfig");
        Contracts.throwIfIllegalLanguage(string, "invalid language value");
        Contracts.throwIfFail(this.createConversationTranscriberFromSourceLangConfig(super.getImpl(), speechConfig.getImpl(), SourceLanguageConfig.fromLanguage(string).getImpl(), null));
        this.initialize();
    }

    public ConversationTranscriber(SpeechConfig speechConfig, String string, AudioConfig audioConfig) {
        super(audioConfig, speechConfig.getTokenCredential());
        this.transcribing = new EventHandlerImpl(this.eventCounter);
        this.transcribed = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        Contracts.throwIfNull(speechConfig, "speechConfig");
        Contracts.throwIfIllegalLanguage(string, "invalid language value");
        if (audioConfig == null) {
            Contracts.throwIfFail(this.createConversationTranscriberFromSourceLangConfig(super.getImpl(), speechConfig.getImpl(), SourceLanguageConfig.fromLanguage(string).getImpl(), null));
        } else {
            Contracts.throwIfFail(this.createConversationTranscriberFromSourceLangConfig(super.getImpl(), speechConfig.getImpl(), SourceLanguageConfig.fromLanguage(string).getImpl(), audioConfig.getImpl()));
        }
        this.initialize();
    }

    public void setAuthorizationToken(String string) {
        Contracts.throwIfNullOrWhitespace(string, "token");
        this.propertyHandle.setProperty(PropertyId.SpeechServiceAuthorization_Token, string);
    }

    public String getAuthorizationToken() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceAuthorization_Token);
    }

    public String getSpeechRecognitionLanguage() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceConnection_RecoLanguage);
    }

    public OutputFormat getOutputFormat() {
        if (this.propertyHandle.getProperty(PropertyId.SpeechServiceResponse_RequestDetailedResultTrueFalse).equals("true")) {
            return OutputFormat.Detailed;
        }
        return OutputFormat.Simple;
    }

    public PropertyCollection getProperties() {
        return this.propertyHandle;
    }

    public Future<Void> startTranscribingAsync() {
        final ConversationTranscriber conversationTranscriber = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        conversationTranscriber.startContinuousRecognition(ConversationTranscriber.this.getImpl());
                    }
                };
                conversationTranscriber.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> stopTranscribingAsync() {
        final ConversationTranscriber conversationTranscriber = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        conversationTranscriber.stopContinuousRecognition(ConversationTranscriber.this.getImpl());
                    }
                };
                conversationTranscriber.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    @Override
    protected void dispose(boolean bl) {
        if (this.disposed) {
            return;
        }
        if (bl) {
            if (this.propertyHandle != null) {
                this.propertyHandle.close();
                this.propertyHandle = null;
            }
            conversationTranscriberObjects.remove(this);
            super.dispose(bl);
        }
    }

    private void initialize() {
        final ConversationTranscriber conversationTranscriber = this;
        this.transcribing.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                conversationTranscriberObjects.add(conversationTranscriber);
                Contracts.throwIfFail(ConversationTranscriber.this.recognizingSetCallback(conversationTranscriber.getImpl().getValue()));
            }
        });
        this.transcribed.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                conversationTranscriberObjects.add(conversationTranscriber);
                Contracts.throwIfFail(ConversationTranscriber.this.recognizedSetCallback(conversationTranscriber.getImpl().getValue()));
            }
        });
        this.canceled.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                conversationTranscriberObjects.add(conversationTranscriber);
                Contracts.throwIfFail(ConversationTranscriber.this.canceledSetCallback(conversationTranscriber.getImpl().getValue()));
            }
        });
        this.sessionStarted.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                conversationTranscriberObjects.add(conversationTranscriber);
                Contracts.throwIfFail(ConversationTranscriber.this.sessionStartedSetCallback(conversationTranscriber.getImpl().getValue()));
            }
        });
        this.sessionStopped.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                conversationTranscriberObjects.add(conversationTranscriber);
                Contracts.throwIfFail(ConversationTranscriber.this.sessionStoppedSetCallback(conversationTranscriber.getImpl().getValue()));
            }
        });
        this.tokenRequested.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                conversationTranscriberObjects.add(conversationTranscriber);
                Contracts.throwIfFail(ConversationTranscriber.this.tokenRefreshSetCallback(conversationTranscriber.getImpl().getValue()));
            }
        });
        this.speechStartDetected.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                conversationTranscriberObjects.add(conversationTranscriber);
                Contracts.throwIfFail(ConversationTranscriber.this.speechStartDetectedSetCallback(conversationTranscriber.getImpl().getValue()));
            }
        });
        this.speechEndDetected.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                conversationTranscriberObjects.add(conversationTranscriber);
                Contracts.throwIfFail(ConversationTranscriber.this.speechEndDetectedSetCallback(conversationTranscriber.getImpl().getValue()));
            }
        });
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBagFromRecognizerHandle(conversationTranscriber.getImpl(), intRef));
        this.propertyHandle = new PropertyCollection(intRef);
        this.setUpTokenRefreshCallback(this.propertyHandle);
    }

    private void recognizingEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            ConversationTranscriptionEventArgs conversationTranscriptionEventArgs = new ConversationTranscriptionEventArgs(l, true);
            EventHandlerImpl<ConversationTranscriptionEventArgs> eventHandlerImpl = this.transcribing;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, conversationTranscriptionEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void recognizedEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            ConversationTranscriptionEventArgs conversationTranscriptionEventArgs = new ConversationTranscriptionEventArgs(l, true);
            EventHandlerImpl<ConversationTranscriptionEventArgs> eventHandlerImpl = this.transcribed;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, conversationTranscriptionEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void canceledEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            ConversationTranscriptionCanceledEventArgs conversationTranscriptionCanceledEventArgs = new ConversationTranscriptionCanceledEventArgs(l, true);
            EventHandlerImpl<ConversationTranscriptionCanceledEventArgs> eventHandlerImpl = this.canceled;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, conversationTranscriptionCanceledEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final native long createConversationTranscriberFromConfig(SafeHandle var1, SafeHandle var2, SafeHandle var3);

    private final native long createConversationTranscriberFromAutoDetectSourceLangConfig(SafeHandle var1, SafeHandle var2, SafeHandle var3, SafeHandle var4);

    private final native long createConversationTranscriberFromSourceLangConfig(SafeHandle var1, SafeHandle var2, SafeHandle var3, SafeHandle var4);
}

