/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.credentialstorage;

import com.microsoft.credentialstorage.SecretStore;
import com.microsoft.credentialstorage.implementation.macosx.KeychainSecurityBackedCredentialStore;
import com.microsoft.credentialstorage.implementation.macosx.KeychainSecurityBackedTokenPairStore;
import com.microsoft.credentialstorage.implementation.macosx.KeychainSecurityBackedTokenStore;
import com.microsoft.credentialstorage.implementation.macosx.KeychainSecurityCliStore;
import com.microsoft.credentialstorage.implementation.memory.InsecureInMemoryStore;
import com.microsoft.credentialstorage.implementation.posix.keyring.GnomeKeyringBackedCredentialStore;
import com.microsoft.credentialstorage.implementation.posix.keyring.GnomeKeyringBackedSecureStore;
import com.microsoft.credentialstorage.implementation.posix.keyring.GnomeKeyringBackedTokenPairStore;
import com.microsoft.credentialstorage.implementation.posix.keyring.GnomeKeyringBackedTokenStore;
import com.microsoft.credentialstorage.implementation.posix.libsecret.LibSecretBackedCredentialStore;
import com.microsoft.credentialstorage.implementation.posix.libsecret.LibSecretBackedSecureStore;
import com.microsoft.credentialstorage.implementation.posix.libsecret.LibSecretBackedTokenPairStore;
import com.microsoft.credentialstorage.implementation.posix.libsecret.LibSecretBackedTokenStore;
import com.microsoft.credentialstorage.implementation.windows.CredManagerBackedCredentialStore;
import com.microsoft.credentialstorage.implementation.windows.CredManagerBackedSecureStore;
import com.microsoft.credentialstorage.implementation.windows.CredManagerBackedTokenPairStore;
import com.microsoft.credentialstorage.implementation.windows.CredManagerBackedTokenStore;
import com.microsoft.credentialstorage.model.StoredCredential;
import com.microsoft.credentialstorage.model.StoredSecret;
import com.microsoft.credentialstorage.model.StoredToken;
import com.microsoft.credentialstorage.model.StoredTokenPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StorageProvider {
    private static final Logger logger = LoggerFactory.getLogger(StorageProvider.class);
    private static final List<SecretStore<StoredToken>> PERSISTED_TOKEN_STORE_CANDIDATES;
    private static final List<SecretStore<StoredTokenPair>> PERSISTED_TOKENPAIR_STORE_CANDIDATES;
    private static final List<SecretStore<StoredCredential>> PERSISTED_CREDENTIAL_STORE_CANDIDATES;

    private StorageProvider() {
    }

    public static SecretStore<StoredToken> getTokenStorage(boolean persist, SecureOption secureOption) {
        Objects.requireNonNull(secureOption, "secureOption cannot be null");
        logger.info("Getting a {} token store that {} be secure", (Object)(persist ? "persistent" : "non-persistent"), (Object)(secureOption == SecureOption.REQUIRED ? "required" : "preferred"));
        NonPersistentStoreGenerator<StoredToken> inMemoryStoreGenerator = new NonPersistentStoreGenerator<StoredToken>(){

            @Override
            public SecretStore<StoredToken> getInsecureNonPersistentStore() {
                return new InsecureInMemoryStore<StoredToken>();
            }

            @Override
            public SecretStore<StoredToken> getSecureNonPersistentStore() {
                logger.warn("Do not have any secure non-persistent stores available.");
                return null;
            }
        };
        return StorageProvider.getStore(persist, secureOption, PERSISTED_TOKEN_STORE_CANDIDATES, inMemoryStoreGenerator);
    }

    public static SecretStore<StoredTokenPair> getTokenPairStorage(boolean persist, SecureOption secureOption) {
        Objects.requireNonNull(secureOption, "secureOption cannot be null");
        logger.info("Getting a {} tokenPair store that {} be secure", (Object)(persist ? "persistent" : "non-persistent"), (Object)(secureOption == SecureOption.REQUIRED ? "required" : "preferred"));
        NonPersistentStoreGenerator<StoredTokenPair> inMemoryStoreGenerator = new NonPersistentStoreGenerator<StoredTokenPair>(){

            @Override
            public SecretStore<StoredTokenPair> getInsecureNonPersistentStore() {
                return new InsecureInMemoryStore<StoredTokenPair>();
            }

            @Override
            public SecretStore<StoredTokenPair> getSecureNonPersistentStore() {
                logger.warn("Do not have any secure non-persistent stores available.");
                return null;
            }
        };
        return StorageProvider.getStore(persist, secureOption, PERSISTED_TOKENPAIR_STORE_CANDIDATES, inMemoryStoreGenerator);
    }

    public static SecretStore<StoredCredential> getCredentialStorage(boolean persist, SecureOption secureOption) {
        Objects.requireNonNull(secureOption, "secureOption cannot be null");
        logger.info("Getting a {} credential store that {} be secure", (Object)(persist ? "persistent" : "non-persistent"), (Object)(secureOption == SecureOption.REQUIRED ? "required" : "preferred"));
        NonPersistentStoreGenerator<StoredCredential> inMemoryStoreGenerator = new NonPersistentStoreGenerator<StoredCredential>(){

            @Override
            public SecretStore<StoredCredential> getInsecureNonPersistentStore() {
                return new InsecureInMemoryStore<StoredCredential>();
            }

            @Override
            public SecretStore<StoredCredential> getSecureNonPersistentStore() {
                logger.warn("Do not have any secure non-persistent stores available.");
                return null;
            }
        };
        return StorageProvider.getStore(persist, secureOption, PERSISTED_CREDENTIAL_STORE_CANDIDATES, inMemoryStoreGenerator);
    }

    private static <E extends StoredSecret> SecretStore<E> findSecureStore(List<SecretStore<E>> stores) {
        for (SecretStore<E> store : stores) {
            if (!store.isSecure()) continue;
            return store;
        }
        return null;
    }

    private static <E extends StoredSecret> SecretStore<E> findPersistedStore(SecureOption secureOption, List<SecretStore<E>> stores) {
        SecretStore<E> candidate = StorageProvider.findSecureStore(stores);
        if (candidate == null && secureOption == SecureOption.PREFERRED && !stores.isEmpty()) {
            candidate = stores.get(0);
        }
        return candidate;
    }

    static <E extends StoredSecret> SecretStore<E> getStore(boolean persist, SecureOption secureOption, List<SecretStore<E>> stores, NonPersistentStoreGenerator<E> nonPersistentStoreGenerator) {
        SecretStore<E> candidate;
        Objects.requireNonNull(nonPersistentStoreGenerator, "nonPersistentStoreGenerator cannot be null.");
        Objects.requireNonNull(stores, "stores cannot be null.");
        if (persist) {
            candidate = StorageProvider.findPersistedStore(secureOption, stores);
        } else {
            candidate = nonPersistentStoreGenerator.getSecureNonPersistentStore();
            if (candidate == null && secureOption == SecureOption.PREFERRED) {
                candidate = nonPersistentStoreGenerator.getInsecureNonPersistentStore();
            }
        }
        return candidate;
    }

    static {
        ArrayList<SecretStore<StoredCredential>> credentialStoreCandidates = new ArrayList<SecretStore<StoredCredential>>();
        ArrayList<SecretStore<StoredToken>> tokenStoreCandidates = new ArrayList<SecretStore<StoredToken>>();
        ArrayList<SecretStore<StoredTokenPair>> tokenPairStoreCandidates = new ArrayList<SecretStore<StoredTokenPair>>();
        if (CredManagerBackedSecureStore.isSupported()) {
            credentialStoreCandidates.add(new CredManagerBackedCredentialStore());
            tokenStoreCandidates.add(new CredManagerBackedTokenStore());
            tokenPairStoreCandidates.add(new CredManagerBackedTokenPairStore());
        }
        if (KeychainSecurityCliStore.isSupported()) {
            credentialStoreCandidates.add(new KeychainSecurityBackedCredentialStore());
            tokenStoreCandidates.add(new KeychainSecurityBackedTokenStore());
            tokenPairStoreCandidates.add(new KeychainSecurityBackedTokenPairStore());
        }
        if (LibSecretBackedSecureStore.isSupported()) {
            credentialStoreCandidates.add(new LibSecretBackedCredentialStore());
            tokenStoreCandidates.add(new LibSecretBackedTokenStore());
            tokenPairStoreCandidates.add(new LibSecretBackedTokenPairStore());
        } else if (GnomeKeyringBackedSecureStore.isSupported()) {
            credentialStoreCandidates.add(new GnomeKeyringBackedCredentialStore());
            tokenStoreCandidates.add(new GnomeKeyringBackedTokenStore());
            tokenPairStoreCandidates.add(new GnomeKeyringBackedTokenPairStore());
        }
        PERSISTED_TOKEN_STORE_CANDIDATES = Collections.unmodifiableList(tokenStoreCandidates);
        PERSISTED_TOKENPAIR_STORE_CANDIDATES = Collections.unmodifiableList(tokenPairStoreCandidates);
        PERSISTED_CREDENTIAL_STORE_CANDIDATES = Collections.unmodifiableList(credentialStoreCandidates);
    }

    static interface NonPersistentStoreGenerator<E extends StoredSecret> {
        public SecretStore<E> getInsecureNonPersistentStore();

        public SecretStore<E> getSecureNonPersistentStore();
    }

    public static enum SecureOption {
        REQUIRED,
        PREFERRED;

    }
}

