/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.credentialstorage.implementation.posix.keyring;

import com.microsoft.credentialstorage.SecretStore;
import com.microsoft.credentialstorage.implementation.posix.internal.GLibInitializer;
import com.microsoft.credentialstorage.implementation.posix.internal.GLibLibrary;
import com.microsoft.credentialstorage.implementation.posix.keyring.GnomeKeyringLibrary;
import com.microsoft.credentialstorage.model.StoredSecret;
import com.sun.jna.Pointer;
import java.util.Objects;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GnomeKeyringBackedSecureStore<E extends StoredSecret>
implements SecretStore<E> {
    protected static final Logger logger = LoggerFactory.getLogger(GnomeKeyringBackedSecureStore.class);
    protected static final GnomeKeyringLibrary INSTANCE = GnomeKeyringBackedSecureStore.getGnomeKeyringLibrary();
    protected static final GnomeKeyringLibrary.GnomeKeyringPasswordSchema SCHEMA = GnomeKeyringBackedSecureStore.getGnomeKeyringPasswordSchema();
    protected static final String APP_NAME = "Credential Secure Storage (keyring)";
    protected static final String ALLOW_UNLOCK_KEYRING = "AUTH_LIB_ALLOW_UNLOCK_GNOME_KEYRING";
    protected static final String ATTRIBUTE_TYPE = "Type";
    protected static final String ATTRIBUTE_KEY = "Key";
    protected static final String ATTRIBUTE_ACCOUNT = "Account";

    @Override
    public E get(String key) {
        Objects.requireNonNull(key, "key cannot be null");
        logger.info("Getting {} for {}", (Object)this.getType(), (Object)key);
        return (E)this.readSecret(key, this::create);
    }

    @Override
    public boolean delete(String key) {
        Objects.requireNonNull(key, "key cannot be null");
        logger.info("Deleting {} for {}", (Object)this.getType(), (Object)key);
        int result = this.deleteSecret(key);
        return GnomeKeyringBackedSecureStore.checkResult(result, "Could not delete secret from storage");
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    public static boolean isSupported() {
        return GnomeKeyringBackedSecureStore.isLinux() && GnomeKeyringBackedSecureStore.isGnomeKeyringSupported();
    }

    protected abstract E create(String var1, char[] var2);

    protected abstract String getType();

    private static boolean isGnomeKeyringSupported() {
        block5: {
            GnomeKeyringLibrary.PointerToPointer keyring_info;
            if (INSTANCE == null || SCHEMA == null || (keyring_info = GnomeKeyringBackedSecureStore.getGnomeKeyringInfoStruct()) == null) break block5;
            try {
                boolean bl = GnomeKeyringBackedSecureStore.isSimplePasswordAPISupported() && GnomeKeyringBackedSecureStore.isGnomeKeyringUnlocked(keyring_info);
                INSTANCE.gnome_keyring_info_free(keyring_info.pointer);
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    INSTANCE.gnome_keyring_info_free(keyring_info.pointer);
                    throw throwable;
                }
                catch (Throwable t) {
                    logger.warn("Gnome Keyring is not available.", t);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T> T readSecret(String key, BiFunction<String, char[], T> mapper) {
        if (INSTANCE != null && SCHEMA != null) {
            Pointer searchAttributes = GLibLibrary.INSTANCE.g_array_new(0, 0, GnomeKeyringLibrary.GNOME_KEYRING_ATTRIBUTE_SIZE);
            Pointer[] foundList = new Pointer[1];
            try {
                GnomeKeyringLibrary.GnomeKeyringAttribute[] attrib;
                GnomeKeyringLibrary.GnomeKeyringFound item;
                INSTANCE.gnome_keyring_attribute_list_append_string(searchAttributes, ATTRIBUTE_TYPE, this.getType());
                INSTANCE.gnome_keyring_attribute_list_append_string(searchAttributes, ATTRIBUTE_KEY, key);
                int result = INSTANCE.gnome_keyring_find_items_sync(0, searchAttributes, foundList);
                if (!GnomeKeyringBackedSecureStore.checkResult(result, "Could not find the item in storage.") || foundList[0] == null || INSTANCE.g_list_length(foundList[0]) <= 0 || (item = INSTANCE.g_list_nth_data(foundList[0], 0)) == null || item.secret == null) return null;
                GLibLibrary.GArray attrArray = new GLibLibrary.GArray(item.attributes);
                if (attrArray.len <= 0) return null;
                GnomeKeyringLibrary.GnomeKeyringAttribute dummyArray = new GnomeKeyringLibrary.GnomeKeyringAttribute(attrArray.data);
                for (GnomeKeyringLibrary.GnomeKeyringAttribute attr : attrib = (GnomeKeyringLibrary.GnomeKeyringAttribute[])dummyArray.toArray(attrArray.len)) {
                    if (!ATTRIBUTE_ACCOUNT.equals(attr.name)) continue;
                    String userName = attr.value;
                    char[] secret = item.secret.toCharArray();
                    String string = mapper.apply(userName, secret);
                    return (T)string;
                }
                return null;
            }
            finally {
                if (foundList[0] != null) {
                    INSTANCE.gnome_keyring_found_list_free(foundList[0]);
                }
                INSTANCE.gnome_keyring_attribute_list_free(searchAttributes);
            }
        } else {
            logger.warn("Gnome Keyring is not available.");
        }
        return null;
    }

    protected int writeSecret(String key, String account, char[] secret) {
        if (INSTANCE != null && SCHEMA != null) {
            return INSTANCE.gnome_keyring_store_password_sync(SCHEMA, GnomeKeyringLibrary.GNOME_KEYRING_DEFAULT, key, new String(secret), ATTRIBUTE_TYPE, this.getType(), ATTRIBUTE_KEY, key, ATTRIBUTE_ACCOUNT, account, null);
        }
        logger.warn("Gnome Keyring is not available.");
        return 2;
    }

    protected int deleteSecret(String key) {
        if (INSTANCE != null && SCHEMA != null) {
            return INSTANCE.gnome_keyring_delete_password_sync(SCHEMA, ATTRIBUTE_TYPE, this.getType(), ATTRIBUTE_KEY, key, null);
        }
        logger.warn("Gnome Keyring is not available.");
        return 2;
    }

    private static GnomeKeyringLibrary.PointerToPointer getGnomeKeyringInfoStruct() {
        GnomeKeyringLibrary.PointerToPointer keyring_info_container = new GnomeKeyringLibrary.PointerToPointer();
        int ret = INSTANCE.gnome_keyring_get_info_sync(GnomeKeyringLibrary.GNOME_KEYRING_DEFAULT, keyring_info_container);
        return GnomeKeyringBackedSecureStore.checkResult(ret, "Could not get default keyring info. GNOME Keyring is not available.") ? keyring_info_container : null;
    }

    private static boolean isSimplePasswordAPISupported() {
        logger.debug("Try access gnome-keyring with dummy data to make sure it's accessible...");
        try {
            GnomeKeyringLibrary.PointerToPointer pPassword = new GnomeKeyringLibrary.PointerToPointer();
            INSTANCE.gnome_keyring_find_password_sync(SCHEMA, pPassword, ATTRIBUTE_TYPE, "NullType", ATTRIBUTE_KEY, "NullKey", null);
        }
        catch (UnsatisfiedLinkError error) {
            logger.warn("GNOME Keyring on this platform does not support the simple password API.  We require gnome-keyring 2.22+.");
            return false;
        }
        return true;
    }

    private static boolean isGnomeKeyringUnlocked(GnomeKeyringLibrary.PointerToPointer keyring_info) {
        boolean locked = INSTANCE.gnome_keyring_info_get_is_locked(keyring_info.pointer);
        if (locked) {
            logger.info("Keyring is locked, most likely due to UI is unavailable or user logged in automatically without supplying a password.");
            boolean allowUnlock = Boolean.parseBoolean(System.getProperty(ALLOW_UNLOCK_KEYRING));
            if (allowUnlock) {
                int ret = INSTANCE.gnome_keyring_unlock_sync(GnomeKeyringLibrary.GNOME_KEYRING_DEFAULT, null);
                return GnomeKeyringBackedSecureStore.checkResult(ret, "Could not unlock keyring. GNOME Keyring is not available.");
            }
            logger.info("Keyring is locked and unavailable, please set variable {} to allow unlocking the keyring with a popup dialog.", (Object)ALLOW_UNLOCK_KEYRING);
            return false;
        }
        return true;
    }

    private static boolean isGnomeKeyringLibraryAvailable() {
        if (GnomeKeyringBackedSecureStore.isLinux()) {
            try {
                GnomeKeyringLibrary ignored = GnomeKeyringLibrary.INSTANCE;
                try {
                    GLibInitializer.getInstance().initialize(APP_NAME);
                }
                catch (UnsatisfiedLinkError error) {
                    logger.warn("Glib not available -- user will see warnings printed on screen. Those warnings are not serious and can be ignored.");
                }
                return true;
            }
            catch (Throwable t) {
                logger.info("gnome-keyring library not loaded", t);
            }
        }
        return false;
    }

    private static GnomeKeyringLibrary getGnomeKeyringLibrary() {
        return GnomeKeyringBackedSecureStore.isGnomeKeyringLibraryAvailable() ? GnomeKeyringLibrary.INSTANCE : null;
    }

    private static GnomeKeyringLibrary.GnomeKeyringPasswordSchema getGnomeKeyringPasswordSchema() {
        try {
            if (GnomeKeyringBackedSecureStore.isGnomeKeyringLibraryAvailable()) {
                logger.info("gnome-keyring library loaded, creating a password SCHEMA");
                GnomeKeyringLibrary.GnomeKeyringPasswordSchema schema = new GnomeKeyringLibrary.GnomeKeyringPasswordSchema();
                schema.item_type = 0;
                schema.attributes = new GnomeKeyringLibrary.GnomeKeyringPasswordSchemaAttribute[4];
                schema.attributes[0] = new GnomeKeyringLibrary.GnomeKeyringPasswordSchemaAttribute();
                schema.attributes[0].name = ATTRIBUTE_TYPE;
                schema.attributes[0].type = 0;
                schema.attributes[1] = new GnomeKeyringLibrary.GnomeKeyringPasswordSchemaAttribute();
                schema.attributes[1].name = ATTRIBUTE_KEY;
                schema.attributes[1].type = 0;
                schema.attributes[2] = new GnomeKeyringLibrary.GnomeKeyringPasswordSchemaAttribute();
                schema.attributes[2].name = ATTRIBUTE_ACCOUNT;
                schema.attributes[2].type = 0;
                schema.attributes[3] = new GnomeKeyringLibrary.GnomeKeyringPasswordSchemaAttribute();
                schema.attributes[3].name = null;
                schema.attributes[3].type = 0;
                return schema;
            }
            logger.info("gnome-keyring library not loaded, return null for SCHEMA");
        }
        catch (Throwable t) {
            logger.warn("creating SCHEMA failed, return null for SCHEMA.", t);
        }
        return null;
    }

    private static boolean isLinux() {
        return System.getProperty("os.name").equals("Linux");
    }

    protected static boolean checkResult(int retCode, String message) {
        if (retCode != 0) {
            logger.error(message);
            try {
                logger.error("Return code: {} description: {}", (Object)retCode, (Object)INSTANCE.gnome_keyring_result_to_message(retCode));
            }
            catch (UnsatisfiedLinkError e) {
                logger.error("Return code: {}", (Object)retCode);
            }
            return false;
        }
        return true;
    }
}

