/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.credentialstorage.implementation.posix.libsecret;

import com.microsoft.credentialstorage.implementation.posix.internal.GLibLibrary;
import com.microsoft.credentialstorage.implementation.posix.libsecret.LibSecretBackedSecureStore;
import com.microsoft.credentialstorage.model.StoredCredential;
import com.sun.jna.ptr.PointerByReference;
import java.util.Objects;

public final class LibSecretBackedCredentialStore
extends LibSecretBackedSecureStore<StoredCredential> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(String key, StoredCredential secret) {
        Objects.requireNonNull(key, "key cannot be null");
        Objects.requireNonNull(secret, "secret cannot be null");
        if (INSTANCE != null && SCHEMA != null) {
            logger.info("Adding a {} for {}", (Object)this.getType(), (Object)key);
            PointerByReference error = new PointerByReference();
            try {
                boolean bl = this.writeSecret(key, secret.getUsername(), secret.getPassword(), error);
                return bl;
            }
            finally {
                if (error.getValue() != null) {
                    GLibLibrary.INSTANCE.g_error_free(error.getValue());
                }
            }
        }
        logger.warn("Libsecret is not available.");
        return false;
    }

    @Override
    protected StoredCredential create(String username, char[] secret) {
        return new StoredCredential(username, secret);
    }

    @Override
    protected String getType() {
        return "Credential";
    }
}

