/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.credentialstorage.implementation.posix.libsecret;

import com.microsoft.credentialstorage.SecretStore;
import com.microsoft.credentialstorage.implementation.posix.internal.GLibInitializer;
import com.microsoft.credentialstorage.implementation.posix.internal.GLibLibrary;
import com.microsoft.credentialstorage.implementation.posix.libsecret.LibSecretLibrary;
import com.microsoft.credentialstorage.model.StoredSecret;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.PointerByReference;
import java.util.Objects;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LibSecretBackedSecureStore<E extends StoredSecret>
implements SecretStore<E> {
    protected static final Logger logger = LoggerFactory.getLogger(LibSecretBackedSecureStore.class);
    protected static final LibSecretLibrary INSTANCE = LibSecretBackedSecureStore.getLibSecretLibrary();
    protected static final LibSecretLibrary.SecretSchema SCHEMA = LibSecretBackedSecureStore.getPasswordSchema();
    protected static final String APP_NAME = "Credential Secure Storage (libsecret)";
    protected static final String ALLOW_UNLOCK_DEFAULT_COLLECTION = "AUTH_LIB_ALLOW_UNLOCK_DEFAULT_COLLECTION";
    protected static final String ATTRIBUTE_TYPE = "Type";
    protected static final String ATTRIBUTE_KEY = "Key";
    protected static final String ATTRIBUTE_ACCOUNT = "Account";

    @Override
    public E get(String key) {
        Objects.requireNonNull(key, "key cannot be null");
        logger.info("Getting {} for {}", (Object)this.getType(), (Object)key);
        return (E)this.readSecret(key, this::create);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(String key) {
        Objects.requireNonNull(key, "key cannot be null");
        logger.info("Deleting {} for {}", (Object)this.getType(), (Object)key);
        PointerByReference error = new PointerByReference();
        try {
            boolean result = this.deleteSecret(key, error);
            boolean bl = result && LibSecretBackedSecureStore.checkResult(error, "Could not delete secret from storage");
            return bl;
        }
        finally {
            if (error.getValue() != null) {
                GLibLibrary.INSTANCE.g_error_free(error.getValue());
            }
        }
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    public static boolean isSupported() {
        return LibSecretBackedSecureStore.isLinux() && LibSecretBackedSecureStore.isLibSecretSupported();
    }

    protected abstract E create(String var1, char[] var2);

    protected abstract String getType();

    public static boolean isLibSecretSupported() {
        try {
            if (INSTANCE != null && SCHEMA != null) {
                return LibSecretBackedSecureStore.isSimplePasswordAPISupported() && LibSecretBackedSecureStore.isDefaultCollectionUnlocked();
            }
        }
        catch (Throwable t) {
            logger.warn("Libsecret is not available.", t);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T> T readSecret(String key, BiFunction<String, char[], T> mapper) {
        if (INSTANCE != null && SCHEMA != null) {
            Pointer searchAttributesHashTable = GLibLibrary.INSTANCE.g_hash_table_new(null, null);
            PointerByReference error = new PointerByReference();
            try {
                GLibLibrary.INSTANCE.g_hash_table_insert(searchAttributesHashTable, LibSecretBackedSecureStore.getPointer(ATTRIBUTE_TYPE), LibSecretBackedSecureStore.getPointer(this.getType()));
                GLibLibrary.INSTANCE.g_hash_table_insert(searchAttributesHashTable, LibSecretBackedSecureStore.getPointer(ATTRIBUTE_KEY), LibSecretBackedSecureStore.getPointer(key));
                Pointer item = INSTANCE.secret_service_search_sync(null, SCHEMA, searchAttributesHashTable, 12, null, error);
                if (!LibSecretBackedSecureStore.checkResult(error, "Could not find the item in storage.")) return null;
                while (item != null) {
                    T userName;
                    GLibLibrary.GList listItem = new GLibLibrary.GList(item);
                    if (listItem.data != null && (userName = LibSecretBackedSecureStore.getStoredSecret(listItem, mapper)) != null) {
                        T t = userName;
                        return t;
                    }
                    item = listItem.next;
                }
                return null;
            }
            finally {
                if (error.getValue() != null) {
                    GLibLibrary.INSTANCE.g_error_free(error.getValue());
                }
                GLibLibrary.INSTANCE.g_hash_table_destroy(searchAttributesHashTable);
            }
        } else {
            logger.warn("Libsecret is not available.");
        }
        return null;
    }

    protected boolean writeSecret(String key, String account, char[] secret, PointerByReference error) {
        if (INSTANCE != null && SCHEMA != null) {
            return INSTANCE.secret_password_store_sync(SCHEMA, "default", key, new String(secret), null, error, ATTRIBUTE_TYPE, this.getType(), ATTRIBUTE_KEY, key, ATTRIBUTE_ACCOUNT, account, null);
        }
        logger.warn("Libsecret is not available.");
        return false;
    }

    protected boolean deleteSecret(String key, PointerByReference error) {
        if (INSTANCE != null && SCHEMA != null) {
            return INSTANCE.secret_password_clear_sync(SCHEMA, null, error, ATTRIBUTE_TYPE, this.getType(), ATTRIBUTE_KEY, key, null);
        }
        logger.warn("Libsecret is not available.");
        return false;
    }

    private static boolean isSimplePasswordAPISupported() {
        logger.debug("Try access libsecret with dummy data to make sure it's accessible...");
        Pointer pPassword = null;
        try {
            PointerByReference error = new PointerByReference();
            pPassword = INSTANCE.secret_password_lookup_sync(SCHEMA, null, error, ATTRIBUTE_TYPE, "NullType", ATTRIBUTE_KEY, "NullKey", null);
            if (pPassword != null) {
                INSTANCE.secret_password_free(pPassword);
            }
        }
        catch (UnsatisfiedLinkError error) {
            logger.warn("libsecret on this platform does not support the simple password API. We require libsecret-1.");
            boolean bl = false;
            return bl;
        }
        finally {
            if (pPassword != null) {
                INSTANCE.secret_password_free(pPassword);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isDefaultCollectionUnlocked() {
        PointerByReference error = new PointerByReference();
        Pointer secretService = null;
        try {
            Pointer secretCollection;
            secretService = INSTANCE.secret_service_get_sync(0, null, error);
            if (secretService != null && LibSecretBackedSecureStore.checkResult(error, "Cannot get service") && (secretCollection = INSTANCE.secret_collection_for_alias_sync(secretService, "default", 0, null, error)) != null && LibSecretBackedSecureStore.checkResult(error, "Cannot get collection by alias")) {
                boolean locked = INSTANCE.secret_collection_get_locked(secretCollection);
                if (locked) {
                    logger.info("Default collection is locked, most likely due to UI is unavailable or user logged in automatically without supplying a password.");
                    boolean allowUnlock = Boolean.parseBoolean(System.getProperty(ALLOW_UNLOCK_DEFAULT_COLLECTION));
                    if (allowUnlock) {
                        PointerByReference unlocked;
                        Pointer objects = GLibLibrary.INSTANCE.g_list_append(null, secretCollection);
                        int unlockedItemCount = INSTANCE.secret_service_unlock_sync(secretService, objects, null, unlocked = new PointerByReference(), error);
                        boolean bl = unlockedItemCount > 1 && LibSecretBackedSecureStore.checkResult(error, "Could not unlock collection. Libsecret collection is not available.");
                        return bl;
                    }
                    logger.info("Collection is locked and unavailable, please set variable {} to allow unlocking the keyring with a popup dialog.", (Object)ALLOW_UNLOCK_DEFAULT_COLLECTION);
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (error.getValue() != null) {
                GLibLibrary.INSTANCE.g_error_free(error.getValue());
            }
            if (secretService != null) {
                INSTANCE.g_object_unref(secretService);
            }
        }
    }

    private static boolean isLibSecretLibraryAvailable() {
        if (LibSecretBackedSecureStore.isLinux()) {
            try {
                LibSecretLibrary ignored = LibSecretLibrary.INSTANCE;
                try {
                    GLibInitializer.getInstance().initialize(APP_NAME);
                }
                catch (UnsatisfiedLinkError error) {
                    logger.warn("Glib not available -- user will see warnings printed on screen. Those warnings are not serious and can be ignored.");
                }
                return true;
            }
            catch (Throwable t) {
                logger.info("libsecret library not loaded", t);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T getStoredSecret(GLibLibrary.GList listItem, BiFunction<String, char[], T> mapper) {
        block7: {
            Pointer attributesHashTable = INSTANCE.secret_item_get_attributes(listItem.data);
            try {
                Pointer secretValue;
                Pointer userNameValue = GLibLibrary.INSTANCE.g_hash_table_lookup(attributesHashTable, LibSecretBackedSecureStore.getPointer(ATTRIBUTE_ACCOUNT));
                if (userNameValue == null || (secretValue = INSTANCE.secret_item_get_secret(listItem.data)) == null) break block7;
                String secretValueText = INSTANCE.secret_value_get_text(secretValue);
                if (secretValueText == null) break block7;
                String userName = userNameValue.getString(0L);
                char[] password = secretValueText.toCharArray();
                T t = mapper.apply(userName, password);
                return t;
                finally {
                    INSTANCE.secret_value_unref(secretValue);
                }
            }
            finally {
                GLibLibrary.INSTANCE.g_hash_table_unref(attributesHashTable);
            }
        }
        return null;
    }

    private static Pointer getPointer(String str) {
        Memory attrTypeKey = new Memory((long)(str.length() + 1));
        attrTypeKey.setString(0L, str);
        return attrTypeKey;
    }

    private static LibSecretLibrary getLibSecretLibrary() {
        return LibSecretBackedSecureStore.isLibSecretLibraryAvailable() ? LibSecretLibrary.INSTANCE : null;
    }

    private static LibSecretLibrary.SecretSchema getPasswordSchema() {
        try {
            if (LibSecretBackedSecureStore.isLibSecretLibraryAvailable()) {
                logger.info("libsecret library loaded, creating a password SCHEMA");
                LibSecretLibrary.SecretSchema schema = new LibSecretLibrary.SecretSchema();
                schema.name = APP_NAME;
                schema.flags = 0;
                schema.attributes = new LibSecretLibrary.SecretSchemaAttribute[4];
                schema.attributes[0] = new LibSecretLibrary.SecretSchemaAttribute();
                schema.attributes[0].name = ATTRIBUTE_TYPE;
                schema.attributes[0].type = 0;
                schema.attributes[1] = new LibSecretLibrary.SecretSchemaAttribute();
                schema.attributes[1].name = ATTRIBUTE_KEY;
                schema.attributes[1].type = 0;
                schema.attributes[2] = new LibSecretLibrary.SecretSchemaAttribute();
                schema.attributes[2].name = ATTRIBUTE_ACCOUNT;
                schema.attributes[2].type = 0;
                schema.attributes[3] = new LibSecretLibrary.SecretSchemaAttribute();
                schema.attributes[3].name = null;
                schema.attributes[3].type = 0;
                return schema;
            }
            logger.info("libsecret library not loaded, return null for SCHEMA");
        }
        catch (Throwable t) {
            logger.warn("creating SCHEMA failed, return null for SCHEMA.", t);
        }
        return null;
    }

    private static boolean isLinux() {
        return System.getProperty("os.name").equals("Linux");
    }

    protected static boolean checkResult(PointerByReference error, String message) {
        if (error.getValue() != null) {
            LibSecretLibrary.GError gError = (LibSecretLibrary.GError)Structure.newInstance(LibSecretLibrary.GError.class, (Pointer)error.getValue());
            gError.read();
            logger.error(message + ": domain: {}, code: {}, description: {}", new Object[]{gError.domain, gError.code, gError.message});
            return false;
        }
        return true;
    }
}

