/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.credentialstorage.implementation.windows;

import com.sun.jna.LastErrorException;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIOptions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

interface CredAdvapi32
extends StdCallLibrary {
    public static final CredAdvapi32 INSTANCE = (CredAdvapi32)Native.load((String)"Advapi32", CredAdvapi32.class, (Map)W32APIOptions.UNICODE_OPTIONS);
    public static final int CRED_FLAGS_PROMPT_NOW = 2;
    public static final int CRED_FLAGS_USERNAME_TARGET = 4;
    public static final int CRED_TYPE_GENERIC = 1;
    public static final int CRED_TYPE_DOMAIN_PASSWORD = 2;
    public static final int CRED_TYPE_DOMAIN_CERTIFICATE = 3;
    public static final int CRED_TYPE_DOMAIN_VISIBLE_PASSWORD = 4;
    public static final int CRED_TYPE_GENERIC_CERTIFICATE = 5;
    public static final int CRED_TYPE_DOMAIN_EXTENDED = 6;
    public static final int CRED_TYPE_MAXIMUM = 7;
    public static final int CRED_TYPE_MAXIMUM_EX = 1007;
    public static final int CRED_PRESERVE_CREDENTIAL_BLOB = 1;
    public static final int CRED_PERSIST_NONE = 0;
    public static final int CRED_PERSIST_SESSION = 1;
    public static final int CRED_PERSIST_LOCAL_MACHINE = 2;
    public static final int CRED_PERSIST_ENTERPRISE = 3;

    public boolean CredRead(String var1, int var2, int var3, PCREDENTIAL var4) throws LastErrorException;

    public boolean CredWrite(CREDENTIAL var1, int var2) throws LastErrorException;

    public boolean CredDelete(String var1, int var2, int var3) throws LastErrorException;

    public void CredFree(Pointer var1) throws LastErrorException;

    public static class PCREDENTIAL
    extends Structure {
        public Pointer credential;

        protected List<String> getFieldOrder() {
            return Collections.singletonList("credential");
        }

        public PCREDENTIAL() {
        }

        public PCREDENTIAL(byte[] data) {
            super((Pointer)new Memory((long)data.length));
            this.getPointer().write(0L, data, 0, data.length);
            this.read();
        }

        public PCREDENTIAL(Pointer memory) {
            super(memory);
            this.read();
        }
    }

    public static class CREDENTIAL
    extends Structure {
        public int Flags;
        public int Type;
        public String TargetName;
        public String Comment;
        public WinBase.FILETIME LastWritten;
        public int CredentialBlobSize;
        public Pointer CredentialBlob;
        public int Persist;
        public int AttributeCount;
        public CREDENTIAL_ATTRIBUTE.ByReference Attributes;
        public String TargetAlias;
        public String UserName;

        protected List<String> getFieldOrder() {
            return Arrays.asList("Flags", "Type", "TargetName", "Comment", "LastWritten", "CredentialBlobSize", "CredentialBlob", "Persist", "AttributeCount", "Attributes", "TargetAlias", "UserName");
        }

        public CREDENTIAL() {
        }

        public CREDENTIAL(int size) {
            super((Pointer)new Memory((long)size));
        }

        public CREDENTIAL(Pointer memory) {
            super(memory);
            this.read();
        }
    }

    public static class PCREDENTIAL_ATTRIBUTE
    extends Structure {
        public Pointer credential_attribute;

        protected List<String> getFieldOrder() {
            return Collections.singletonList("credential_attribute");
        }

        public PCREDENTIAL_ATTRIBUTE() {
        }

        public PCREDENTIAL_ATTRIBUTE(byte[] data) {
            super((Pointer)new Memory((long)data.length));
            this.getPointer().write(0L, data, 0, data.length);
            this.read();
        }

        public PCREDENTIAL_ATTRIBUTE(Pointer memory) {
            super(memory);
            this.read();
        }
    }

    public static class CREDENTIAL_ATTRIBUTE
    extends Structure {
        public String Keyword;
        public int Flags;
        public int ValueSize;
        public Pointer Value;

        protected List<String> getFieldOrder() {
            return Arrays.asList("Keyword", "Flags", "ValueSize", "Value");
        }

        public static class ByReference
        extends CREDENTIAL_ATTRIBUTE
        implements Structure.ByReference {
        }
    }
}

