/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.credentialstorage.implementation.windows;

import com.microsoft.credentialstorage.SecretStore;
import com.microsoft.credentialstorage.implementation.windows.CredAdvapi32;
import com.microsoft.credentialstorage.model.StoredSecret;
import com.sun.jna.LastErrorException;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CredManagerBackedSecureStore<E extends StoredSecret>
implements SecretStore<E> {
    protected static final Logger logger = LoggerFactory.getLogger(CredManagerBackedSecureStore.class);
    private static final Charset UTF16LE = StandardCharsets.UTF_16LE;
    private final CredAdvapi32 INSTANCE = CredManagerBackedSecureStore.getCredAdvapi32Instance();

    @Override
    public E get(String key) {
        Objects.requireNonNull(key, "key cannot be null");
        logger.info("Getting secret for {}", (Object)key);
        return (E)this.readSecret(key, this::createSecret);
    }

    @Override
    public boolean delete(String key) {
        Objects.requireNonNull(key, "key cannot be null");
        logger.info("Deleting secret for {}", (Object)key);
        return this.deleteSecret(key);
    }

    @Override
    public abstract boolean add(String var1, E var2);

    @Override
    public boolean isSecure() {
        return true;
    }

    public static boolean isSupported() {
        return CredManagerBackedSecureStore.isWindows();
    }

    protected abstract E create(String var1, char[] var2);

    private E createSecret(CredAdvapi32.CREDENTIAL credential) {
        char[] secret = this.getSecret(credential);
        return this.create(credential.UserName, secret);
    }

    protected char[] getSecret(CredAdvapi32.CREDENTIAL credential) {
        byte[] secretData = credential.CredentialBlob.getByteArray(0L, credential.CredentialBlobSize);
        return CredManagerBackedSecureStore.UTF16LEGetString(secretData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T readSecret(String key, Function<CredAdvapi32.CREDENTIAL, T> mapper) {
        T cred = null;
        CredAdvapi32.PCREDENTIAL pcredential = new CredAdvapi32.PCREDENTIAL();
        try {
            boolean read;
            CredAdvapi32 credAdvapi32 = this.INSTANCE;
            synchronized (credAdvapi32) {
                read = this.INSTANCE.CredRead(key, 1, 0, pcredential);
            }
            if (read) {
                Object credential = new CredAdvapi32.CREDENTIAL(pcredential.credential);
                cred = mapper.apply((CredAdvapi32.CREDENTIAL)((Object)credential));
            }
        }
        catch (LastErrorException e) {
            logger.error("Getting secret failed. {}", (Object)e.getMessage());
        }
        finally {
            if (pcredential.credential != null) {
                CredAdvapi32 credAdvapi32 = this.INSTANCE;
                synchronized (credAdvapi32) {
                    this.INSTANCE.CredFree(pcredential.credential);
                }
            }
        }
        return cred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean writeSecret(String key, String username, char[] secret) {
        byte[] credBlob = CredManagerBackedSecureStore.UTF16LEGetBytes(secret);
        CredAdvapi32.CREDENTIAL cred = CredManagerBackedSecureStore.buildCred(key, username, credBlob);
        try {
            CredAdvapi32 credAdvapi32 = this.INSTANCE;
            synchronized (credAdvapi32) {
                this.INSTANCE.CredWrite(cred, 0);
            }
            boolean bl = true;
            return bl;
        }
        catch (LastErrorException e) {
            logger.error("Adding secret failed. {}", (Object)e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            cred.CredentialBlob.clear((long)credBlob.length);
            Arrays.fill(credBlob, (byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean deleteSecret(String key) {
        try {
            CredAdvapi32 credAdvapi32 = this.INSTANCE;
            synchronized (credAdvapi32) {
                return this.INSTANCE.CredDelete(key, 1, 0);
            }
        }
        catch (LastErrorException e) {
            logger.error("Deleting secret failed. {}", (Object)e.getMessage());
            return false;
        }
    }

    static CredAdvapi32.CREDENTIAL buildCred(String key, String username, byte[] credentialBlob) {
        CredAdvapi32.CREDENTIAL credential = new CredAdvapi32.CREDENTIAL();
        credential.Flags = 0;
        credential.Type = 1;
        credential.TargetName = key;
        credential.CredentialBlobSize = credentialBlob.length;
        credential.CredentialBlob = CredManagerBackedSecureStore.getPointer(credentialBlob);
        credential.Persist = 2;
        credential.UserName = username;
        return credential;
    }

    private static Pointer getPointer(byte[] array) {
        Memory p = new Memory((long)array.length);
        p.write(0L, array, 0, array.length);
        return p;
    }

    private static byte[] UTF16LEGetBytes(char[] value) {
        return UTF16LE.encode(CharBuffer.wrap(value)).array();
    }

    private static char[] UTF16LEGetString(byte[] bytes) {
        return UTF16LE.decode(ByteBuffer.wrap(bytes)).array();
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    private static CredAdvapi32 getCredAdvapi32Instance() {
        if (CredManagerBackedSecureStore.isSupported()) {
            return CredAdvapi32.INSTANCE;
        }
        logger.warn("Returning a dummy library on non Windows platform.  This is a bug unless you are testing.");
        return new CredAdvapi32(){

            @Override
            public boolean CredRead(String targetName, int type, int flags, CredAdvapi32.PCREDENTIAL pcredential) throws LastErrorException {
                return false;
            }

            @Override
            public boolean CredWrite(CredAdvapi32.CREDENTIAL credential, int flags) throws LastErrorException {
                return false;
            }

            @Override
            public boolean CredDelete(String targetName, int type, int flags) throws LastErrorException {
                return false;
            }

            @Override
            public void CredFree(Pointer credential) throws LastErrorException {
            }
        };
    }
}

