/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.credentialstorage.implementation.windows;

import com.microsoft.credentialstorage.implementation.windows.CredAdvapi32;
import com.microsoft.credentialstorage.implementation.windows.CredManagerBackedSecureStore;
import com.microsoft.credentialstorage.model.StoredToken;
import com.microsoft.credentialstorage.model.StoredTokenPair;
import com.microsoft.credentialstorage.model.StoredTokenType;
import java.util.Objects;

public final class CredManagerBackedTokenPairStore
extends CredManagerBackedSecureStore<StoredTokenPair> {
    private static final String ACCESS_TOKEN = "/accessToken";
    private static final String REFRESH_TOKEN = "/refreshToken";

    @Override
    public StoredTokenPair get(String key) {
        Objects.requireNonNull(key, "key cannot be null");
        logger.info("Getting secret for {}", (Object)key);
        StoredToken accessToken = this.readSecret(key + ACCESS_TOKEN, credential -> new StoredToken(this.getSecret((CredAdvapi32.CREDENTIAL)((Object)credential)), StoredTokenType.ACCESS));
        StoredToken refreshToken = this.readSecret(key + REFRESH_TOKEN, credential -> new StoredToken(this.getSecret((CredAdvapi32.CREDENTIAL)((Object)credential)), StoredTokenType.REFRESH));
        if (accessToken == null && refreshToken == null) {
            return null;
        }
        return new StoredTokenPair(accessToken, refreshToken);
    }

    @Override
    public boolean add(String key, StoredTokenPair secret) {
        Objects.requireNonNull(key, "key cannot be null");
        Objects.requireNonNull(secret, "secret cannot be null");
        logger.info("Adding secret for {}", (Object)key);
        return this.writeSecret(key + ACCESS_TOKEN, secret.getAccessToken().getType().getDescription(), secret.getAccessToken().getValue()) && this.writeSecret(key + REFRESH_TOKEN, secret.getRefreshToken().getType().getDescription(), secret.getRefreshToken().getValue());
    }

    @Override
    public boolean delete(String key) {
        Objects.requireNonNull(key, "key cannot be null");
        logger.info("Deleting secret for {}", (Object)key);
        return this.deleteSecret(key + ACCESS_TOKEN) && this.deleteSecret(key + REFRESH_TOKEN);
    }

    @Override
    protected StoredTokenPair create(String username, char[] secret) {
        return null;
    }
}

