/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.credentialstorage.model;

import java.util.Arrays;
import java.util.Objects;

final class ClearableValue {
    private static final char[] EMPTY = new char[0];
    private volatile char[] value;

    ClearableValue(char[] value) {
        Objects.requireNonNull(value, "The value parameter is null");
        this.value = Arrays.copyOf(value, value.length);
    }

    char[] getValue() {
        return this.value;
    }

    void clear() {
        if (EMPTY == this.value) {
            return;
        }
        char[] tempValue = this.value;
        this.value = EMPTY;
        Arrays.fill(tempValue, '\u0000');
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClearableValue that = (ClearableValue)o;
        return Arrays.equals(this.value, that.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }
}

