/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.credentialstorage.model;

import com.microsoft.credentialstorage.model.ClearableValue;
import com.microsoft.credentialstorage.model.StoredSecret;
import java.util.Objects;

public final class StoredCredential
implements StoredSecret {
    private static final int USERNAME_MAX_LENGTH = 511;
    private static final int PASSWORD_MAX_LENGTH = 2047;
    private final String username;
    private final ClearableValue password;

    public StoredCredential(String username, char[] password) {
        Objects.requireNonNull(username, "The username parameter is null");
        if (username.length() > 511) {
            throw new IllegalArgumentException(String.format("The username parameter cannot be longer than %1$d characters.", 511));
        }
        this.username = username;
        Objects.requireNonNull(password, "The password parameter is null");
        if (password.length > 2047) {
            throw new IllegalArgumentException(String.format("The password parameter cannot be longer than %1$d characters.", 2047));
        }
        this.password = new ClearableValue(password);
    }

    public String getUsername() {
        return this.username;
    }

    public char[] getPassword() {
        return this.password.getValue();
    }

    @Override
    public void clear() {
        this.password.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredCredential that = (StoredCredential)o;
        return this.username.equals(that.username) && this.password.equals(that.password);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.password);
    }
}

