/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.credentialstorage.model;

import com.microsoft.credentialstorage.model.ClearableValue;
import com.microsoft.credentialstorage.model.StoredSecret;
import com.microsoft.credentialstorage.model.StoredTokenType;
import java.util.Objects;

public final class StoredToken
implements StoredSecret {
    private final StoredTokenType type;
    private final ClearableValue value;

    public StoredToken(char[] value, StoredTokenType type) {
        Objects.requireNonNull(value, "The value parameter is null");
        Objects.requireNonNull(type, "The type parameter is null");
        this.type = type;
        this.value = new ClearableValue(value);
    }

    public StoredTokenType getType() {
        return this.type;
    }

    public char[] getValue() {
        return this.value.getValue();
    }

    @Override
    public void clear() {
        this.value.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredToken token = (StoredToken)o;
        return this.type == token.type && this.value.equals(token.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.value});
    }
}

