/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.credentialstorage.model;

import com.microsoft.credentialstorage.model.StoredSecret;
import com.microsoft.credentialstorage.model.StoredToken;
import com.microsoft.credentialstorage.model.StoredTokenType;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public final class StoredTokenPair
implements StoredSecret {
    private final StoredToken accessToken;
    private final StoredToken refreshToken;

    public StoredTokenPair(StoredToken accessToken, StoredToken refreshToken) {
        Objects.requireNonNull(accessToken, "The accessToken parameter is null");
        Objects.requireNonNull(refreshToken, "The refreshToken parameter is null");
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
    }

    public StoredTokenPair(char[] accessToken, char[] refreshToken, Map<String, String> parameters) {
        Objects.requireNonNull(accessToken, "The accessToken parameter is null");
        Objects.requireNonNull(refreshToken, "The refreshToken parameter is null");
        Objects.requireNonNull(parameters, "The parameters parameter is null");
        this.accessToken = new StoredToken(accessToken, StoredTokenType.ACCESS);
        this.refreshToken = new StoredToken(refreshToken, StoredTokenType.REFRESH);
    }

    public StoredTokenPair(char[] accessToken, char[] refreshToken) {
        this(accessToken, refreshToken, Collections.emptyMap());
    }

    public StoredToken getAccessToken() {
        return this.accessToken;
    }

    public StoredToken getRefreshToken() {
        return this.refreshToken;
    }

    @Override
    public void clear() {
        this.accessToken.clear();
        this.refreshToken.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredTokenPair tokenPair = (StoredTokenPair)o;
        return this.accessToken.equals(tokenPair.accessToken) && this.refreshToken.equals(tokenPair.refreshToken);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.refreshToken);
    }
}

