/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.durabletask.azurefunctions;

import com.microsoft.azure.functions.HttpRequestMessage;
import com.microsoft.azure.functions.HttpResponseMessage;
import com.microsoft.azure.functions.HttpStatus;
import com.microsoft.durabletask.DurableTaskClient;
import com.microsoft.durabletask.DurableTaskGrpcClientBuilder;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class DurableClientContext {
    private String rpcBaseUrl;
    private String taskHubName;
    private String requiredQueryStringParameters;

    public String getTaskHubName() {
        return this.taskHubName;
    }

    public DurableTaskClient getClient() {
        URL rpcURL;
        if (this.rpcBaseUrl == null || this.rpcBaseUrl.length() == 0) {
            throw new IllegalStateException("The client context wasn't populated with an RPC base URL!");
        }
        try {
            rpcURL = new URL(this.rpcBaseUrl);
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException("The client context RPC base URL was invalid!", ex);
        }
        return new DurableTaskGrpcClientBuilder().port(rpcURL.getPort()).build();
    }

    public HttpResponseMessage createCheckStatusResponse(HttpRequestMessage<?> request, String instanceId) {
        String encodedInstanceId;
        String baseUrl = request.getUri().getScheme() + "://" + request.getUri().getAuthority();
        try {
            encodedInstanceId = URLEncoder.encode(instanceId, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException("Failed to encode the instance ID: " + instanceId, ex);
        }
        String instanceStatusURL = baseUrl + "/runtime/webhooks/durabletask/instances/" + encodedInstanceId;
        return request.createResponseBuilder(HttpStatus.ACCEPTED).header("Location", instanceStatusURL + "?" + this.requiredQueryStringParameters).header("Content-Type", "application/json").body((Object)new HttpCreateCheckStatusResponse(instanceId, instanceStatusURL, this.requiredQueryStringParameters)).build();
    }

    private static class HttpCreateCheckStatusResponse {
        public final String id;
        public final String purgeHistoryDeleteUri;
        public final String sendEventPostUri;
        public final String statusQueryGetUri;
        public final String terminatePostUri;

        public HttpCreateCheckStatusResponse(String instanceId, String instanceStatusURL, String requiredQueryStringParameters) {
            this.id = instanceId;
            this.purgeHistoryDeleteUri = instanceStatusURL + "?" + requiredQueryStringParameters;
            this.sendEventPostUri = instanceStatusURL + "/raiseEvent/{eventName}?" + requiredQueryStringParameters;
            this.statusQueryGetUri = instanceStatusURL + "?" + requiredQueryStringParameters;
            this.terminatePostUri = instanceStatusURL + "/terminate?reason={text}&" + requiredQueryStringParameters;
        }
    }
}

