/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.durabletask.azurefunctions.internal.middleware;

import com.microsoft.azure.functions.internal.spi.middleware.Middleware;
import com.microsoft.azure.functions.internal.spi.middleware.MiddlewareChain;
import com.microsoft.azure.functions.internal.spi.middleware.MiddlewareContext;
import com.microsoft.durabletask.OrchestrationRunner;
import com.microsoft.durabletask.OrchestratorBlockedException;

public class OrchestrationMiddleware
implements Middleware {
    private static final String ORCHESTRATION_TRIGGER = "DurableOrchestrationTrigger";

    public void invoke(MiddlewareContext context, MiddlewareChain chain) throws Exception {
        String parameterName = context.getParameterName(ORCHESTRATION_TRIGGER);
        if (parameterName == null) {
            chain.doNext(context);
            return;
        }
        String orchestratorRequestEncodedProtoBytes = (String)context.getParameterValue(parameterName);
        String orchestratorOutputEncodedProtoBytes = OrchestrationRunner.loadAndRun((String)orchestratorRequestEncodedProtoBytes, taskOrchestrationContext -> {
            try {
                context.updateParameterValue(parameterName, (Object)taskOrchestrationContext);
                chain.doNext(context);
                return context.getReturnValue();
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof OrchestratorBlockedException) {
                    throw (OrchestratorBlockedException)cause;
                }
                throw new RuntimeException("Unexpected failure in the task execution", e);
            }
        });
        context.updateReturnValue((Object)orchestratorOutputEncodedProtoBytes);
    }
}

