/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.durabletask.azurefunctions;

import com.microsoft.azure.functions.HttpRequestMessage;
import com.microsoft.azure.functions.HttpResponseMessage;
import com.microsoft.azure.functions.HttpStatus;
import com.microsoft.durabletask.DurableTaskClient;
import com.microsoft.durabletask.DurableTaskGrpcClientBuilder;
import com.microsoft.durabletask.OrchestrationMetadata;
import com.microsoft.durabletask.azurefunctions.HttpManagementPayload;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.TimeoutException;

public class DurableClientContext {
    private String rpcBaseUrl;
    private String taskHubName;
    private String requiredQueryStringParameters;
    private DurableTaskClient client;

    public String getTaskHubName() {
        return this.taskHubName;
    }

    public DurableTaskClient getClient() {
        URL rpcURL;
        if (this.rpcBaseUrl == null || this.rpcBaseUrl.length() == 0) {
            throw new IllegalStateException("The client context wasn't populated with an RPC base URL!");
        }
        try {
            rpcURL = new URL(this.rpcBaseUrl);
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException("The client context RPC base URL was invalid!", ex);
        }
        this.client = new DurableTaskGrpcClientBuilder().port(rpcURL.getPort()).build();
        return this.client;
    }

    public HttpResponseMessage waitForCompletionOrCreateCheckStatusResponse(HttpRequestMessage<?> request, String instanceId, Duration timeout) {
        if (this.client == null) {
            this.client = this.getClient();
        }
        try {
            OrchestrationMetadata orchestration = this.client.waitForInstanceCompletion(instanceId, timeout, true);
            return request.createResponseBuilder(HttpStatus.ACCEPTED).header("Content-Type", "application/json").body((Object)orchestration.getSerializedOutput()).build();
        }
        catch (TimeoutException e) {
            return this.createCheckStatusResponse(request, instanceId);
        }
    }

    public HttpResponseMessage createCheckStatusResponse(HttpRequestMessage<?> request, String instanceId) {
        return request.createResponseBuilder(HttpStatus.ACCEPTED).header("Location", this.getInstanceStatusURL(request, instanceId) + "?" + this.requiredQueryStringParameters).header("Content-Type", "application/json").body((Object)this.getClientResponseLinks(request, instanceId)).build();
    }

    public HttpManagementPayload createHttpManagementPayload(HttpRequestMessage<?> request, String instanceId) {
        return this.getClientResponseLinks(request, instanceId);
    }

    private HttpManagementPayload getClientResponseLinks(HttpRequestMessage<?> request, String instanceId) {
        String instanceStatusURL = this.getInstanceStatusURL(request, instanceId);
        return new HttpManagementPayload(instanceId, instanceStatusURL, this.requiredQueryStringParameters);
    }

    private String getInstanceStatusURL(HttpRequestMessage<?> request, String instanceId) {
        String encodedInstanceId;
        String baseUrl = request.getUri().getScheme() + "://" + request.getUri().getAuthority();
        try {
            encodedInstanceId = URLEncoder.encode(instanceId, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException("Failed to encode the instance ID: " + instanceId, ex);
        }
        return baseUrl + "/runtime/webhooks/durabletask/instances/" + encodedInstanceId;
    }
}

