/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.durabletask;

import com.google.protobuf.StringValue;
import com.google.protobuf.Timestamp;
import com.microsoft.durabletask.DataConverter;
import com.microsoft.durabletask.DurableTaskClient;
import com.microsoft.durabletask.DurableTaskGrpcClientBuilder;
import com.microsoft.durabletask.Helpers;
import com.microsoft.durabletask.JacksonDataConverter;
import com.microsoft.durabletask.NewOrchestrationInstanceOptions;
import com.microsoft.durabletask.OrchestrationMetadata;
import com.microsoft.durabletask.OrchestrationRuntimeStatus;
import com.microsoft.durabletask.OrchestrationStatusQuery;
import com.microsoft.durabletask.OrchestrationStatusQueryResult;
import com.microsoft.durabletask.PurgeInstanceCriteria;
import com.microsoft.durabletask.PurgeResult;
import com.microsoft.durabletask.implementation.protobuf.OrchestratorService;
import com.microsoft.durabletask.implementation.protobuf.TaskHubSidecarServiceGrpc;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class DurableTaskGrpcClient
extends DurableTaskClient {
    private static final int DEFAULT_PORT = 4001;
    private static final Logger logger = Logger.getLogger(DurableTaskGrpcClient.class.getPackage().getName());
    private final DataConverter dataConverter;
    private final ManagedChannel managedSidecarChannel;
    private final TaskHubSidecarServiceGrpc.TaskHubSidecarServiceBlockingStub sidecarClient;

    DurableTaskGrpcClient(DurableTaskGrpcClientBuilder builder) {
        Channel sidecarGrpcChannel;
        DataConverter dataConverter = this.dataConverter = builder.dataConverter != null ? builder.dataConverter : new JacksonDataConverter();
        if (builder.channel != null) {
            this.managedSidecarChannel = null;
            sidecarGrpcChannel = builder.channel;
        } else {
            int port = 4001;
            if (builder.port > 0) {
                port = builder.port;
            }
            this.managedSidecarChannel = ManagedChannelBuilder.forAddress((String)"127.0.0.1", (int)port).usePlaintext().build();
            sidecarGrpcChannel = this.managedSidecarChannel;
        }
        this.sidecarClient = TaskHubSidecarServiceGrpc.newBlockingStub(sidecarGrpcChannel);
    }

    @Override
    public void close() {
        if (this.managedSidecarChannel != null) {
            try {
                this.managedSidecarChannel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public String scheduleNewOrchestrationInstance(String orchestratorName, NewOrchestrationInstanceOptions options) {
        Instant startTime;
        Object input;
        if (orchestratorName == null || orchestratorName.length() == 0) {
            throw new IllegalArgumentException("A non-empty orchestrator name must be specified.");
        }
        Helpers.throwIfArgumentNull(options, "options");
        OrchestratorService.CreateInstanceRequest.Builder builder = OrchestratorService.CreateInstanceRequest.newBuilder();
        builder.setName(orchestratorName);
        String instanceId = options.getInstanceId();
        if (instanceId == null) {
            instanceId = UUID.randomUUID().toString();
        }
        builder.setInstanceId(instanceId);
        String version = options.getVersion();
        if (version != null) {
            builder.setVersion(StringValue.of((String)version));
        }
        if ((input = options.getInput()) != null) {
            String serializedInput = this.dataConverter.serialize(input);
            builder.setInput(StringValue.of((String)serializedInput));
        }
        if ((startTime = options.getStartTime()) != null) {
            Timestamp ts = DataConverter.getTimestampFromInstant(startTime);
            builder.setScheduledStartTimestamp(ts);
        }
        OrchestratorService.CreateInstanceRequest request = builder.build();
        OrchestratorService.CreateInstanceResponse response = this.sidecarClient.startInstance(request);
        return response.getInstanceId();
    }

    @Override
    public void raiseEvent(String instanceId, String eventName, Object eventPayload) {
        Helpers.throwIfArgumentNull(instanceId, "instanceId");
        Helpers.throwIfArgumentNull(eventName, "eventName");
        OrchestratorService.RaiseEventRequest.Builder builder = OrchestratorService.RaiseEventRequest.newBuilder().setInstanceId(instanceId).setName(eventName);
        if (eventPayload != null) {
            String serializedPayload = this.dataConverter.serialize(eventPayload);
            builder.setInput(StringValue.of((String)serializedPayload));
        }
        OrchestratorService.RaiseEventRequest request = builder.build();
        this.sidecarClient.raiseEvent(request);
    }

    @Override
    public OrchestrationMetadata getInstanceMetadata(String instanceId, boolean getInputsAndOutputs) {
        OrchestratorService.GetInstanceRequest request = OrchestratorService.GetInstanceRequest.newBuilder().setInstanceId(instanceId).setGetInputsAndOutputs(getInputsAndOutputs).build();
        OrchestratorService.GetInstanceResponse response = this.sidecarClient.getInstance(request);
        return new OrchestrationMetadata(response, this.dataConverter, request.getGetInputsAndOutputs());
    }

    @Override
    public OrchestrationMetadata waitForInstanceStart(String instanceId, Duration timeout, boolean getInputsAndOutputs) throws TimeoutException {
        OrchestratorService.GetInstanceResponse response;
        OrchestratorService.GetInstanceRequest request = OrchestratorService.GetInstanceRequest.newBuilder().setInstanceId(instanceId).setGetInputsAndOutputs(getInputsAndOutputs).build();
        if (timeout == null || timeout.isNegative() || timeout.isZero()) {
            timeout = Duration.ofMinutes(10L);
        }
        TaskHubSidecarServiceGrpc.TaskHubSidecarServiceBlockingStub grpcClient = (TaskHubSidecarServiceGrpc.TaskHubSidecarServiceBlockingStub)this.sidecarClient.withDeadlineAfter(timeout.toMillis(), TimeUnit.MILLISECONDS);
        try {
            response = grpcClient.waitForInstanceStart(request);
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.DEADLINE_EXCEEDED) {
                throw new TimeoutException("Start orchestration timeout reached.");
            }
            throw e;
        }
        return new OrchestrationMetadata(response, this.dataConverter, request.getGetInputsAndOutputs());
    }

    @Override
    public OrchestrationMetadata waitForInstanceCompletion(String instanceId, Duration timeout, boolean getInputsAndOutputs) throws TimeoutException {
        OrchestratorService.GetInstanceResponse response;
        OrchestratorService.GetInstanceRequest request = OrchestratorService.GetInstanceRequest.newBuilder().setInstanceId(instanceId).setGetInputsAndOutputs(getInputsAndOutputs).build();
        if (timeout == null || timeout.isNegative() || timeout.isZero()) {
            timeout = Duration.ofMinutes(10L);
        }
        TaskHubSidecarServiceGrpc.TaskHubSidecarServiceBlockingStub grpcClient = (TaskHubSidecarServiceGrpc.TaskHubSidecarServiceBlockingStub)this.sidecarClient.withDeadlineAfter(timeout.toMillis(), TimeUnit.MILLISECONDS);
        try {
            response = grpcClient.waitForInstanceCompletion(request);
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.DEADLINE_EXCEEDED) {
                throw new TimeoutException("Orchestration instance completion timeout reached.");
            }
            throw e;
        }
        return new OrchestrationMetadata(response, this.dataConverter, request.getGetInputsAndOutputs());
    }

    @Override
    public void terminate(String instanceId, @Nullable Object output) {
        Helpers.throwIfArgumentNull(instanceId, "instanceId");
        String serializeOutput = this.dataConverter.serialize(output);
        logger.fine(() -> String.format("Terminating instance %s and setting output to: %s", instanceId, serializeOutput != null ? serializeOutput : "(null)"));
        OrchestratorService.TerminateRequest.Builder builder = OrchestratorService.TerminateRequest.newBuilder().setInstanceId(instanceId).setOutput(StringValue.of((String)serializeOutput));
        this.sidecarClient.terminateInstance(builder.build());
    }

    @Override
    public OrchestrationStatusQueryResult queryInstances(OrchestrationStatusQuery query) {
        OrchestratorService.InstanceQuery.Builder instanceQueryBuilder = OrchestratorService.InstanceQuery.newBuilder();
        Optional.ofNullable(query.getCreatedTimeFrom()).ifPresent(createdTimeFrom -> instanceQueryBuilder.setCreatedTimeFrom(DataConverter.getTimestampFromInstant(createdTimeFrom)));
        Optional.ofNullable(query.getCreatedTimeTo()).ifPresent(createdTimeTo -> instanceQueryBuilder.setCreatedTimeTo(DataConverter.getTimestampFromInstant(createdTimeTo)));
        Optional.ofNullable(query.getContinuationToken()).ifPresent(token -> instanceQueryBuilder.setContinuationToken(StringValue.of((String)token)));
        Optional.ofNullable(query.getInstanceIdPrefix()).ifPresent(prefix -> instanceQueryBuilder.setInstanceIdPrefix(StringValue.of((String)prefix)));
        instanceQueryBuilder.setFetchInputsAndOutputs(query.isFetchInputsAndOutputs());
        instanceQueryBuilder.setMaxInstanceCount(query.getMaxInstanceCount());
        query.getRuntimeStatusList().forEach(runtimeStatus -> Optional.ofNullable(runtimeStatus).ifPresent(status -> instanceQueryBuilder.addRuntimeStatus(OrchestrationRuntimeStatus.toProtobuf(status))));
        query.getTaskHubNames().forEach(taskHubName -> Optional.ofNullable(taskHubName).ifPresent(name -> instanceQueryBuilder.addTaskHubNames(StringValue.of((String)name))));
        OrchestratorService.QueryInstancesResponse queryInstancesResponse = this.sidecarClient.queryInstances(OrchestratorService.QueryInstancesRequest.newBuilder().setQuery(instanceQueryBuilder).build());
        return this.toQueryResult(queryInstancesResponse, query.isFetchInputsAndOutputs());
    }

    private OrchestrationStatusQueryResult toQueryResult(OrchestratorService.QueryInstancesResponse queryInstancesResponse, boolean fetchInputsAndOutputs) {
        ArrayList<OrchestrationMetadata> metadataList = new ArrayList<OrchestrationMetadata>();
        queryInstancesResponse.getOrchestrationStateList().forEach(state -> metadataList.add(new OrchestrationMetadata((OrchestratorService.OrchestrationState)state, this.dataConverter, fetchInputsAndOutputs)));
        return new OrchestrationStatusQueryResult(metadataList, queryInstancesResponse.getContinuationToken().getValue());
    }

    @Override
    public void createTaskHub(boolean recreateIfExists) {
        this.sidecarClient.createTaskHub(OrchestratorService.CreateTaskHubRequest.newBuilder().setRecreateIfExists(recreateIfExists).build());
    }

    @Override
    public void deleteTaskHub() {
        this.sidecarClient.deleteTaskHub(OrchestratorService.DeleteTaskHubRequest.newBuilder().build());
    }

    @Override
    public PurgeResult purgeInstance(String instanceId) {
        OrchestratorService.PurgeInstancesRequest request = OrchestratorService.PurgeInstancesRequest.newBuilder().setInstanceId(instanceId).build();
        OrchestratorService.PurgeInstancesResponse response = this.sidecarClient.purgeInstances(request);
        return this.toPurgeResult(response);
    }

    @Override
    public PurgeResult purgeInstances(PurgeInstanceCriteria purgeInstanceCriteria) throws TimeoutException {
        OrchestratorService.PurgeInstanceFilter.Builder builder = OrchestratorService.PurgeInstanceFilter.newBuilder();
        builder.setCreatedTimeFrom(DataConverter.getTimestampFromInstant(purgeInstanceCriteria.getCreatedTimeFrom()));
        Optional.ofNullable(purgeInstanceCriteria.getCreatedTimeTo()).ifPresent(createdTimeTo -> builder.setCreatedTimeTo(DataConverter.getTimestampFromInstant(createdTimeTo)));
        purgeInstanceCriteria.getRuntimeStatusList().forEach(runtimeStatus -> Optional.ofNullable(runtimeStatus).ifPresent(status -> builder.addRuntimeStatus(OrchestrationRuntimeStatus.toProtobuf(status))));
        Duration timeout = purgeInstanceCriteria.getTimeout();
        if (timeout == null || timeout.isNegative() || timeout.isZero()) {
            timeout = Duration.ofMinutes(4L);
        }
        TaskHubSidecarServiceGrpc.TaskHubSidecarServiceBlockingStub grpcClient = (TaskHubSidecarServiceGrpc.TaskHubSidecarServiceBlockingStub)this.sidecarClient.withDeadlineAfter(timeout.toMillis(), TimeUnit.MILLISECONDS);
        try {
            OrchestratorService.PurgeInstancesResponse response = grpcClient.purgeInstances(OrchestratorService.PurgeInstancesRequest.newBuilder().setPurgeInstanceFilter(builder).build());
            return this.toPurgeResult(response);
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.DEADLINE_EXCEEDED) {
                String timeOutException = String.format("Purge instances timeout duration of %s reached.", timeout);
                throw new TimeoutException(timeOutException);
            }
            throw e;
        }
    }

    private PurgeResult toPurgeResult(OrchestratorService.PurgeInstancesResponse response) {
        return new PurgeResult(response.getDeletedInstanceCount());
    }
}

