/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.durabletask;

import com.google.protobuf.StringValue;
import com.microsoft.durabletask.DataConverter;
import com.microsoft.durabletask.DurableTaskGrpcWorkerBuilder;
import com.microsoft.durabletask.FailureDetails;
import com.microsoft.durabletask.JacksonDataConverter;
import com.microsoft.durabletask.TaskActivityExecutor;
import com.microsoft.durabletask.TaskActivityFactory;
import com.microsoft.durabletask.TaskOrchestrationExecutor;
import com.microsoft.durabletask.TaskOrchestrationFactory;
import com.microsoft.durabletask.TaskOrchestratorResult;
import com.microsoft.durabletask.implementation.protobuf.OrchestratorService;
import com.microsoft.durabletask.implementation.protobuf.TaskHubSidecarServiceGrpc;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DurableTaskGrpcWorker
implements AutoCloseable {
    private static final int DEFAULT_PORT = 4001;
    private static final Logger logger = Logger.getLogger(DurableTaskGrpcWorker.class.getPackage().getName());
    private final HashMap<String, TaskOrchestrationFactory> orchestrationFactories = new HashMap();
    private final HashMap<String, TaskActivityFactory> activityFactories = new HashMap();
    private final ManagedChannel managedSidecarChannel;
    private final DataConverter dataConverter;
    private final TaskHubSidecarServiceGrpc.TaskHubSidecarServiceBlockingStub sidecarClient;

    DurableTaskGrpcWorker(DurableTaskGrpcWorkerBuilder builder) {
        Channel sidecarGrpcChannel;
        this.orchestrationFactories.putAll(builder.orchestrationFactories);
        this.activityFactories.putAll(builder.activityFactories);
        if (builder.channel != null) {
            this.managedSidecarChannel = null;
            sidecarGrpcChannel = builder.channel;
        } else {
            int port = 4001;
            if (builder.port > 0) {
                port = builder.port;
            }
            this.managedSidecarChannel = ManagedChannelBuilder.forAddress((String)"127.0.0.1", (int)port).usePlaintext().build();
            sidecarGrpcChannel = this.managedSidecarChannel;
        }
        this.sidecarClient = TaskHubSidecarServiceGrpc.newBlockingStub(sidecarGrpcChannel);
        this.dataConverter = builder.dataConverter != null ? builder.dataConverter : new JacksonDataConverter();
    }

    public void start() {
        new Thread(this::startAndBlock).start();
    }

    @Override
    public void close() {
        if (this.managedSidecarChannel != null) {
            try {
                this.managedSidecarChannel.shutdownNow().awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private String getSidecarAddress() {
        return this.sidecarClient.getChannel().authority();
    }

    public void startAndBlock() {
        logger.log(Level.INFO, "Durable Task worker is connecting to sidecar at {0}.", this.getSidecarAddress());
        TaskOrchestrationExecutor taskOrchestrationExecutor = new TaskOrchestrationExecutor(this.orchestrationFactories, this.dataConverter, logger);
        TaskActivityExecutor taskActivityExecutor = new TaskActivityExecutor(this.activityFactories, this.dataConverter, logger);
        while (true) {
            try {
                block7: while (true) {
                    OrchestratorService.GetWorkItemsRequest getWorkItemsRequest = OrchestratorService.GetWorkItemsRequest.newBuilder().build();
                    Iterator<OrchestratorService.WorkItem> workItemStream = this.sidecarClient.getWorkItems(getWorkItemsRequest);
                    while (true) {
                        if (!workItemStream.hasNext()) continue block7;
                        OrchestratorService.WorkItem workItem = workItemStream.next();
                        OrchestratorService.WorkItem.RequestCase requestType = workItem.getRequestCase();
                        if (requestType == OrchestratorService.WorkItem.RequestCase.ORCHESTRATORREQUEST) {
                            OrchestratorService.OrchestratorRequest orchestratorRequest = workItem.getOrchestratorRequest();
                            TaskOrchestratorResult taskOrchestratorResult = taskOrchestrationExecutor.execute(orchestratorRequest.getPastEventsList(), orchestratorRequest.getNewEventsList());
                            OrchestratorService.OrchestratorResponse response = OrchestratorService.OrchestratorResponse.newBuilder().setInstanceId(orchestratorRequest.getInstanceId()).addAllActions(taskOrchestratorResult.getActions()).setCustomStatus(StringValue.of((String)taskOrchestratorResult.getCustomStatus())).build();
                            this.sidecarClient.completeOrchestratorTask(response);
                            continue;
                        }
                        if (requestType == OrchestratorService.WorkItem.RequestCase.ACTIVITYREQUEST) {
                            OrchestratorService.ActivityRequest activityRequest = workItem.getActivityRequest();
                            String output = null;
                            OrchestratorService.TaskFailureDetails failureDetails = null;
                            try {
                                output = taskActivityExecutor.execute(activityRequest.getName(), activityRequest.getInput().getValue(), activityRequest.getTaskId());
                            }
                            catch (Throwable e) {
                                failureDetails = OrchestratorService.TaskFailureDetails.newBuilder().setErrorType(e.getClass().getName()).setErrorMessage(e.getMessage()).setStackTrace(StringValue.of((String)FailureDetails.getFullStackTrace(e))).build();
                            }
                            OrchestratorService.ActivityResponse.Builder responseBuilder = OrchestratorService.ActivityResponse.newBuilder().setInstanceId(activityRequest.getOrchestrationInstance().getInstanceId()).setTaskId(activityRequest.getTaskId());
                            if (output != null) {
                                responseBuilder.setResult(StringValue.of((String)output));
                            }
                            if (failureDetails != null) {
                                responseBuilder.setFailureDetails(failureDetails);
                            }
                            this.sidecarClient.completeActivityTask(responseBuilder.build());
                            continue;
                        }
                        logger.log(Level.WARNING, "Received and dropped an unknown '{0}' work-item from the sidecar.", (Object)requestType);
                    }
                    break;
                }
            }
            catch (StatusRuntimeException e) {
                if (e.getStatus().getCode() == Status.Code.UNAVAILABLE) {
                    logger.log(Level.INFO, "The sidecar at address {0} is unavailable. Will continue retrying.", this.getSidecarAddress());
                } else if (e.getStatus().getCode() == Status.Code.CANCELLED) {
                    logger.log(Level.INFO, "Durable Task worker has disconnected from {0}.", this.getSidecarAddress());
                } else {
                    logger.log(Level.WARNING, "Unexpected failure connecting to {0}.", this.getSidecarAddress());
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ex) {
                    return;
                }
            }
        }
    }

    public void stop() {
        this.close();
    }
}

