/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.durabletask;

import com.google.protobuf.StringValue;
import com.google.protobuf.Timestamp;
import com.microsoft.durabletask.CompositeTaskFailedException;
import com.microsoft.durabletask.DataConverter;
import com.microsoft.durabletask.FailureDetails;
import com.microsoft.durabletask.Helpers;
import com.microsoft.durabletask.NonDeterministicOrchestratorException;
import com.microsoft.durabletask.OrchestratorBlockedException;
import com.microsoft.durabletask.RetryContext;
import com.microsoft.durabletask.RetryHandler;
import com.microsoft.durabletask.RetryPolicy;
import com.microsoft.durabletask.Task;
import com.microsoft.durabletask.TaskCanceledException;
import com.microsoft.durabletask.TaskFailedException;
import com.microsoft.durabletask.TaskOptions;
import com.microsoft.durabletask.TaskOrchestration;
import com.microsoft.durabletask.TaskOrchestrationContext;
import com.microsoft.durabletask.TaskOrchestrationFactory;
import com.microsoft.durabletask.TaskOrchestratorResult;
import com.microsoft.durabletask.implementation.protobuf.OrchestratorService;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class TaskOrchestrationExecutor {
    private static final String EMPTY_STRING = "";
    private final HashMap<String, TaskOrchestrationFactory> orchestrationFactories;
    private final DataConverter dataConverter;
    private final Logger logger;
    private final Duration maximumTimerInterval;

    public TaskOrchestrationExecutor(HashMap<String, TaskOrchestrationFactory> orchestrationFactories, DataConverter dataConverter, Duration maximumTimerInterval, Logger logger) {
        this.orchestrationFactories = orchestrationFactories;
        this.dataConverter = dataConverter;
        this.maximumTimerInterval = maximumTimerInterval;
        this.logger = logger;
    }

    public TaskOrchestratorResult execute(List<OrchestratorService.HistoryEvent> pastEvents, List<OrchestratorService.HistoryEvent> newEvents) {
        ContextImplTask context = new ContextImplTask(pastEvents, newEvents);
        boolean completed = false;
        try {
            while (context.processNextEvent()) {
            }
            completed = true;
        }
        catch (OrchestratorBlockedException orchestratorBlockedException) {
            this.logger.fine("The orchestrator has yielded and will await for new events.");
        }
        catch (Exception e) {
            this.logger.warning("The orchestrator failed with an unhandled exception: " + e.toString());
            context.fail(new FailureDetails(e));
        }
        if (context.continuedAsNew && !context.isComplete || completed && context.pendingActions.isEmpty() && !context.waitingForEvents()) {
            context.complete(null);
        }
        return new TaskOrchestratorResult(context.pendingActions.values(), context.getCustomStatus());
    }

    static /* synthetic */ Duration access$700(TaskOrchestrationExecutor x0) {
        return x0.maximumTimerInterval;
    }

    static /* synthetic */ Logger access$800(TaskOrchestrationExecutor x0) {
        return x0.logger;
    }

    @FunctionalInterface
    private static interface TaskFactory<V> {
        public Task<V> create();
    }

    private class ContextImplTask
    implements TaskOrchestrationContext {
        private String orchestratorName;
        private String rawInput;
        private String instanceId;
        private Instant currentInstant;
        private boolean isComplete;
        private boolean isSuspended;
        private boolean isReplaying = true;
        private final LinkedHashMap<Integer, OrchestratorService.OrchestratorAction> pendingActions = new LinkedHashMap();
        private final HashMap<Integer, TaskRecord<?>> openTasks = new HashMap();
        private final LinkedHashMap<String, Queue<TaskRecord<?>>> outstandingEvents = new LinkedHashMap();
        private final LinkedList<OrchestratorService.HistoryEvent> unprocessedEvents = new LinkedList();
        private final Queue<OrchestratorService.HistoryEvent> eventsWhileSuspended = new ArrayDeque<OrchestratorService.HistoryEvent>();
        private final DataConverter dataConverter = TaskOrchestrationExecutor.access$600(TaskOrchestrationExecutor.this);
        private final Duration maximumTimerInterval = TaskOrchestrationExecutor.access$700(TaskOrchestrationExecutor.this);
        private final Logger logger = TaskOrchestrationExecutor.access$800(TaskOrchestrationExecutor.this);
        private final OrchestrationHistoryIterator historyEventPlayer;
        private int sequenceNumber;
        private boolean continuedAsNew;
        private Object continuedAsNewInput;
        private boolean preserveUnprocessedEvents;
        private Object customStatus;

        public ContextImplTask(List<OrchestratorService.HistoryEvent> pastEvents, List<OrchestratorService.HistoryEvent> newEvents) {
            this.historyEventPlayer = new OrchestrationHistoryIterator(pastEvents, newEvents);
        }

        @Override
        public String getName() {
            return this.orchestratorName;
        }

        private void setName(String name) {
            this.orchestratorName = name;
        }

        private void setInput(String rawInput) {
            this.rawInput = rawInput;
        }

        public <T> T getInput(Class<T> targetType) {
            if (this.rawInput == null || this.rawInput.length() == 0) {
                return null;
            }
            return this.dataConverter.deserialize(this.rawInput, targetType);
        }

        @Override
        public String getInstanceId() {
            return this.instanceId;
        }

        private void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public Instant getCurrentInstant() {
            return this.currentInstant;
        }

        private void setCurrentInstant(Instant instant) {
            this.currentInstant = instant;
        }

        private String getCustomStatus() {
            return this.customStatus != null ? this.dataConverter.serialize(this.customStatus) : TaskOrchestrationExecutor.EMPTY_STRING;
        }

        @Override
        public void setCustomStatus(Object customStatus) {
            this.customStatus = customStatus;
        }

        @Override
        public void clearCustomStatus() {
            this.setCustomStatus(null);
        }

        @Override
        public boolean getIsReplaying() {
            return this.isReplaying;
        }

        private void setDoneReplaying() {
            this.isReplaying = false;
        }

        public <V> Task<V> completedTask(V value) {
            CompletableTask<V> task = new CompletableTask<V>();
            task.complete(value);
            return task;
        }

        @Override
        public <V> Task<List<V>> allOf(List<Task<V>> tasks) {
            Helpers.throwIfArgumentNull(tasks, "tasks");
            CompletableFuture[] futures = (CompletableFuture[])tasks.stream().map(t -> t.future).toArray(CompletableFuture[]::new);
            return new CompletableTask<List<V>>(((CompletableFuture)CompletableFuture.allOf(futures).thenApply(x -> {
                ArrayList results = new ArrayList(futures.length);
                for (CompletableFuture cf : futures) {
                    try {
                        results.add(cf.get());
                    }
                    catch (Exception ex) {
                        results.add(null);
                    }
                }
                return results;
            })).exceptionally(throwable -> {
                ArrayList<Exception> exceptions = new ArrayList<Exception>(futures.length);
                for (CompletableFuture cf : futures) {
                    try {
                        cf.get();
                    }
                    catch (ExecutionException ex) {
                        exceptions.add((Exception)ex.getCause());
                    }
                    catch (Exception ex) {
                        exceptions.add(ex);
                    }
                }
                throw new CompositeTaskFailedException(String.format("%d out of %d tasks failed with an exception. See the exceptions list for details.", exceptions.size(), futures.length), exceptions);
            }));
        }

        @Override
        public Task<Task<?>> anyOf(List<Task<?>> tasks) {
            Helpers.throwIfArgumentNull(tasks, "tasks");
            CompletableFuture[] futures = (CompletableFuture[])tasks.stream().map(t -> t.future).toArray(CompletableFuture[]::new);
            return new CompletableTask((CompletableFuture<Task<?>>)CompletableFuture.anyOf(futures).thenApply(x -> {
                for (Task task : tasks) {
                    if (!task.isDone()) continue;
                    return task;
                }
                return this.completedTask(null);
            }));
        }

        @Override
        public <V> Task<V> callActivity(String name, @Nullable Object input, @Nullable TaskOptions options, Class<V> returnType) {
            Helpers.throwIfOrchestratorComplete(this.isComplete);
            Helpers.throwIfArgumentNull(name, "name");
            Helpers.throwIfArgumentNull(returnType, "returnType");
            if (input instanceof TaskOptions) {
                throw new IllegalArgumentException("TaskOptions cannot be used as an input. Did you call the wrong method overload?");
            }
            String serializedInput = this.dataConverter.serialize(input);
            OrchestratorService.ScheduleTaskAction.Builder scheduleTaskBuilder = OrchestratorService.ScheduleTaskAction.newBuilder().setName(name);
            if (serializedInput != null) {
                scheduleTaskBuilder.setInput(StringValue.of((String)serializedInput));
            }
            TaskFactory taskFactory = () -> {
                int id = this.sequenceNumber++;
                this.pendingActions.put(id, OrchestratorService.OrchestratorAction.newBuilder().setId(id).setScheduleTask(scheduleTaskBuilder).build());
                if (!this.isReplaying) {
                    this.logger.fine(() -> String.format("%s: calling activity '%s' (#%d) with serialized input: %s", this.instanceId, name, id, serializedInput != null ? serializedInput : "(null)"));
                }
                CompletableTask task = new CompletableTask();
                TaskRecord record = new TaskRecord(task, name, returnType);
                this.openTasks.put(id, record);
                return task;
            };
            return this.createAppropriateTask(taskFactory, options);
        }

        @Override
        public void continueAsNew(Object input, boolean preserveUnprocessedEvents) {
            Helpers.throwIfOrchestratorComplete(this.isComplete);
            this.continuedAsNew = true;
            this.continuedAsNewInput = input;
            this.preserveUnprocessedEvents = preserveUnprocessedEvents;
        }

        @Override
        public void sendEvent(String instanceId, String eventName, Object eventData) {
            Helpers.throwIfOrchestratorComplete(this.isComplete);
            Helpers.throwIfArgumentNullOrWhiteSpace(instanceId, "instanceId");
            int id = this.sequenceNumber++;
            String serializedEventData = this.dataConverter.serialize(eventData);
            OrchestratorService.OrchestrationInstance.Builder OrchestrationInstanceBuilder = OrchestratorService.OrchestrationInstance.newBuilder().setInstanceId(instanceId);
            OrchestratorService.SendEventAction.Builder builder = OrchestratorService.SendEventAction.newBuilder().setInstance(OrchestrationInstanceBuilder).setName(eventName);
            if (serializedEventData != null) {
                builder.setData(StringValue.of((String)serializedEventData));
            }
            this.pendingActions.put(id, OrchestratorService.OrchestratorAction.newBuilder().setId(id).setSendEvent(builder).build());
            if (!this.isReplaying) {
                this.logger.fine(() -> String.format("%s: sending event '%s' (#%d) with serialized event data: %s", this.instanceId, eventName, id, serializedEventData != null ? serializedEventData : "(null)"));
            }
        }

        @Override
        public <V> Task<V> callSubOrchestrator(String name, @Nullable Object input, @Nullable String instanceId, @Nullable TaskOptions options, Class<V> returnType) {
            Helpers.throwIfOrchestratorComplete(this.isComplete);
            Helpers.throwIfArgumentNull(name, "name");
            Helpers.throwIfArgumentNull(returnType, "returnType");
            if (input instanceof TaskOptions) {
                throw new IllegalArgumentException("TaskOptions cannot be used as an input. Did you call the wrong method overload?");
            }
            String serializedInput = this.dataConverter.serialize(input);
            OrchestratorService.CreateSubOrchestrationAction.Builder createSubOrchestrationActionBuilder = OrchestratorService.CreateSubOrchestrationAction.newBuilder().setName(name);
            if (serializedInput != null) {
                createSubOrchestrationActionBuilder.setInput(StringValue.of((String)serializedInput));
            }
            if (instanceId == null) {
                instanceId = UUID.randomUUID().toString();
            }
            createSubOrchestrationActionBuilder.setInstanceId(instanceId);
            TaskFactory taskFactory = () -> {
                int id = this.sequenceNumber++;
                this.pendingActions.put(id, OrchestratorService.OrchestratorAction.newBuilder().setId(id).setCreateSubOrchestration(createSubOrchestrationActionBuilder).build());
                if (!this.isReplaying) {
                    this.logger.fine(() -> String.format("%s: calling sub-orchestration '%s' (#%d) with serialized input: %s", this.instanceId, name, id, serializedInput != null ? serializedInput : "(null)"));
                }
                CompletableTask task = new CompletableTask();
                TaskRecord record = new TaskRecord(task, name, returnType);
                this.openTasks.put(id, record);
                return task;
            };
            return this.createAppropriateTask(taskFactory, options);
        }

        private <V> Task<V> createAppropriateTask(TaskFactory<V> taskFactory, TaskOptions options) {
            if (options != null && options.hasRetryPolicy()) {
                return new RetriableTask<V>((TaskOrchestrationContext)this, taskFactory, options.getRetryPolicy());
            }
            if (options != null && options.hasRetryHandler()) {
                return new RetriableTask<V>((TaskOrchestrationContext)this, taskFactory, options.getRetryHandler());
            }
            return taskFactory.create();
        }

        @Override
        public <V> Task<V> waitForExternalEvent(String name, Duration timeout, Class<V> dataType) {
            boolean hasTimeout;
            Helpers.throwIfOrchestratorComplete(this.isComplete);
            Helpers.throwIfArgumentNull(name, "name");
            Helpers.throwIfArgumentNull(dataType, "dataType");
            int id = this.sequenceNumber++;
            ExternalEventTask eventTask = new ExternalEventTask(name, id, timeout);
            for (OrchestratorService.HistoryEvent e : this.unprocessedEvents) {
                OrchestratorService.EventRaisedEvent existing = e.getEventRaised();
                if (!name.equalsIgnoreCase(existing.getName())) continue;
                String rawEventData = existing.getInput().getValue();
                V data = this.dataConverter.deserialize(rawEventData, dataType);
                eventTask.complete(data);
                this.unprocessedEvents.remove(e);
                return eventTask;
            }
            boolean bl = hasTimeout = !Helpers.isInfiniteTimeout(timeout);
            if (hasTimeout && timeout.isZero()) {
                ((CompletableTask)eventTask).cancel();
                return eventTask;
            }
            TaskRecord record = new TaskRecord(eventTask, name, dataType);
            Queue eventQueue = this.outstandingEvents.computeIfAbsent(name, k -> new LinkedList());
            eventQueue.add(record);
            if (hasTimeout) {
                this.createTimer((Duration)timeout).future.thenRun(() -> {
                    if (!eventTask.isDone()) {
                        eventQueue.removeIf(t -> ((TaskRecord)t).task == eventTask);
                        if (eventQueue.isEmpty()) {
                            this.outstandingEvents.remove(name);
                        }
                        ((CompletableTask)eventTask).cancel();
                    }
                });
            }
            return eventTask;
        }

        private void handleTaskScheduled(OrchestratorService.HistoryEvent e) {
            int taskId = e.getEventId();
            OrchestratorService.TaskScheduledEvent taskScheduled = e.getTaskScheduled();
            OrchestratorService.OrchestratorAction taskAction = (OrchestratorService.OrchestratorAction)this.pendingActions.remove(taskId);
            if (taskAction == null) {
                String message = String.format("Non-deterministic orchestrator detected: a history event scheduling an activity task with sequence ID %d and name '%s' was replayed but the current orchestrator implementation didn't actually schedule this task. Was a change made to the orchestrator code after this instance had already started running?", taskId, taskScheduled.getName());
                throw new NonDeterministicOrchestratorException(message);
            }
        }

        private void handleTaskCompleted(OrchestratorService.HistoryEvent e) {
            OrchestratorService.TaskCompletedEvent completedEvent = e.getTaskCompleted();
            int taskId = completedEvent.getTaskScheduledId();
            TaskRecord<?> record = this.openTasks.remove(taskId);
            if (record == null) {
                this.logger.warning("Discarding a potentially duplicate TaskCompleted event with ID = " + taskId);
                return;
            }
            String rawResult = completedEvent.getResult().getValue();
            if (!this.isReplaying) {
                this.logger.fine(() -> String.format("%s: Activity '%s' (#%d) completed with serialized output: %s", this.instanceId, record.getTaskName(), taskId, rawResult != null ? rawResult : "(null)"));
            }
            Object result = this.dataConverter.deserialize(rawResult, record.getDataType());
            CompletableTask<?> task = record.getTask();
            task.complete(result);
        }

        private void handleTaskFailed(OrchestratorService.HistoryEvent e) {
            OrchestratorService.TaskFailedEvent failedEvent = e.getTaskFailed();
            int taskId = failedEvent.getTaskScheduledId();
            TaskRecord<?> record = this.openTasks.remove(taskId);
            if (record == null) {
                return;
            }
            FailureDetails details = new FailureDetails(failedEvent.getFailureDetails());
            if (!this.isReplaying) {
                // empty if block
            }
            CompletableTask<?> task = record.getTask();
            TaskFailedException exception = new TaskFailedException(((TaskRecord)record).taskName, taskId, details);
            task.completeExceptionally(exception);
        }

        private void handleEventRaised(OrchestratorService.HistoryEvent e) {
            OrchestratorService.EventRaisedEvent eventRaised = e.getEventRaised();
            String eventName = eventRaised.getName();
            Queue<TaskRecord<?>> outstandingEventQueue = this.outstandingEvents.get(eventName);
            if (outstandingEventQueue == null) {
                this.unprocessedEvents.add(e);
                return;
            }
            TaskRecord<?> matchingTaskRecord = outstandingEventQueue.remove();
            if (outstandingEventQueue.isEmpty()) {
                this.outstandingEvents.remove(eventName);
            }
            String rawResult = eventRaised.getInput().getValue();
            Object result = this.dataConverter.deserialize(rawResult, matchingTaskRecord.getDataType());
            CompletableTask<?> task = matchingTaskRecord.getTask();
            task.complete(result);
        }

        private void handleEventWhileSuspended(OrchestratorService.HistoryEvent historyEvent) {
            if (historyEvent.getEventTypeCase() != OrchestratorService.HistoryEvent.EventTypeCase.EXECUTIONSUSPENDED) {
                this.eventsWhileSuspended.offer(historyEvent);
            }
        }

        private void handleExecutionSuspended(OrchestratorService.HistoryEvent historyEvent) {
            this.isSuspended = true;
        }

        private void handleExecutionResumed(OrchestratorService.HistoryEvent historyEvent) {
            this.isSuspended = false;
            while (!this.eventsWhileSuspended.isEmpty()) {
                this.processEvent(this.eventsWhileSuspended.poll());
            }
        }

        @Override
        public Task<Void> createTimer(Duration duration) {
            Helpers.throwIfOrchestratorComplete(this.isComplete);
            Helpers.throwIfArgumentNull(duration, "duration");
            Instant finalFireAt = this.currentInstant.plus(duration);
            return this.createTimer(finalFireAt);
        }

        @Override
        public Task<Void> createTimer(ZonedDateTime zonedDateTime) {
            Helpers.throwIfOrchestratorComplete(this.isComplete);
            Helpers.throwIfArgumentNull(zonedDateTime, "zonedDateTime");
            Instant finalFireAt = zonedDateTime.toInstant();
            return this.createTimer(finalFireAt);
        }

        private Task<Void> createTimer(Instant finalFireAt) {
            Duration remainingTime = Duration.between(this.currentInstant, finalFireAt);
            while (remainingTime.compareTo(this.maximumTimerInterval) > 0) {
                Instant nextFireAt = this.currentInstant.plus(this.maximumTimerInterval);
                this.createInstantTimer(this.sequenceNumber++, nextFireAt).await();
                remainingTime = Duration.between(this.currentInstant, finalFireAt);
            }
            return this.createInstantTimer(this.sequenceNumber++, finalFireAt);
        }

        private Task<Void> createInstantTimer(int id, Instant fireAt) {
            Timestamp ts = DataConverter.getTimestampFromInstant(fireAt);
            this.pendingActions.put(id, OrchestratorService.OrchestratorAction.newBuilder().setId(id).setCreateTimer(OrchestratorService.CreateTimerAction.newBuilder().setFireAt(ts)).build());
            if (!this.isReplaying) {
                // empty if block
            }
            CompletableTask<Void> timerTask = new CompletableTask<Void>();
            TaskRecord<Void> record = new TaskRecord<Void>(timerTask, "(timer)", Void.class);
            this.openTasks.put(id, record);
            return timerTask;
        }

        private void handleTimerCreated(OrchestratorService.HistoryEvent e) {
            int timerEventId = e.getEventId();
            if (timerEventId == -100) {
                return;
            }
            OrchestratorService.TimerCreatedEvent timerCreatedEvent = e.getTimerCreated();
            OrchestratorService.OrchestratorAction timerAction = (OrchestratorService.OrchestratorAction)this.pendingActions.remove(timerEventId);
            if (timerAction == null) {
                String message = String.format("Non-deterministic orchestrator detected: a history event creating a timer with ID %d and fire-at time %s was replayed but the current orchestrator implementation didn't actually create this timer. Was a change made to the orchestrator code after this instance had already started running?", timerEventId, DataConverter.getInstantFromTimestamp(timerCreatedEvent.getFireAt()));
                throw new NonDeterministicOrchestratorException(message);
            }
        }

        public void handleTimerFired(OrchestratorService.HistoryEvent e) {
            OrchestratorService.TimerFiredEvent timerFiredEvent = e.getTimerFired();
            int timerEventId = timerFiredEvent.getTimerId();
            TaskRecord<?> record = this.openTasks.remove(timerEventId);
            if (record == null) {
                return;
            }
            if (!this.isReplaying) {
                // empty if block
            }
            CompletableTask<?> task = record.getTask();
            task.complete(null);
        }

        private void handleSubOrchestrationCreated(OrchestratorService.HistoryEvent e) {
            int taskId = e.getEventId();
            OrchestratorService.SubOrchestrationInstanceCreatedEvent subOrchestrationInstanceCreated = e.getSubOrchestrationInstanceCreated();
            OrchestratorService.OrchestratorAction taskAction = (OrchestratorService.OrchestratorAction)this.pendingActions.remove(taskId);
            if (taskAction == null) {
                String message = String.format("Non-deterministic orchestrator detected: a history event scheduling an sub-orchestration task with sequence ID %d and name '%s' was replayed but the current orchestrator implementation didn't actually schedule this task. Was a change made to the orchestrator code after this instance had already started running?", taskId, subOrchestrationInstanceCreated.getName());
                throw new NonDeterministicOrchestratorException(message);
            }
        }

        private void handleSubOrchestrationCompleted(OrchestratorService.HistoryEvent e) {
            OrchestratorService.SubOrchestrationInstanceCompletedEvent subOrchestrationInstanceCompletedEvent = e.getSubOrchestrationInstanceCompleted();
            int taskId = subOrchestrationInstanceCompletedEvent.getTaskScheduledId();
            TaskRecord<?> record = this.openTasks.remove(taskId);
            if (record == null) {
                this.logger.warning("Discarding a potentially duplicate SubOrchestrationInstanceCompleted event with ID = " + taskId);
                return;
            }
            String rawResult = subOrchestrationInstanceCompletedEvent.getResult().getValue();
            if (!this.isReplaying) {
                this.logger.fine(() -> String.format("%s: Sub-orchestrator '%s' (#%d) completed with serialized output: %s", this.instanceId, record.getTaskName(), taskId, rawResult != null ? rawResult : "(null)"));
            }
            Object result = this.dataConverter.deserialize(rawResult, record.getDataType());
            CompletableTask<?> task = record.getTask();
            task.complete(result);
        }

        private void handleSubOrchestrationFailed(OrchestratorService.HistoryEvent e) {
            OrchestratorService.SubOrchestrationInstanceFailedEvent subOrchestrationInstanceFailedEvent = e.getSubOrchestrationInstanceFailed();
            int taskId = subOrchestrationInstanceFailedEvent.getTaskScheduledId();
            TaskRecord<?> record = this.openTasks.remove(taskId);
            if (record == null) {
                return;
            }
            FailureDetails details = new FailureDetails(subOrchestrationInstanceFailedEvent.getFailureDetails());
            if (!this.isReplaying) {
                // empty if block
            }
            CompletableTask<?> task = record.getTask();
            TaskFailedException exception = new TaskFailedException(((TaskRecord)record).taskName, taskId, details);
            task.completeExceptionally(exception);
        }

        private void handleExecutionTerminated(OrchestratorService.HistoryEvent e) {
            OrchestratorService.ExecutionTerminatedEvent executionTerminatedEvent = e.getExecutionTerminated();
            this.completeInternal(executionTerminatedEvent.getInput().getValue(), null, OrchestratorService.OrchestrationStatus.ORCHESTRATION_STATUS_TERMINATED);
        }

        @Override
        public void complete(Object output) {
            if (this.continuedAsNew) {
                this.completeInternal(this.continuedAsNewInput, OrchestratorService.OrchestrationStatus.ORCHESTRATION_STATUS_CONTINUED_AS_NEW);
            } else {
                this.completeInternal(output, OrchestratorService.OrchestrationStatus.ORCHESTRATION_STATUS_COMPLETED);
            }
        }

        public void fail(FailureDetails failureDetails) {
            this.completeInternal(null, failureDetails, OrchestratorService.OrchestrationStatus.ORCHESTRATION_STATUS_FAILED);
        }

        private void completeInternal(Object output, OrchestratorService.OrchestrationStatus runtimeStatus) {
            String resultAsJson = TaskOrchestrationExecutor.this.dataConverter.serialize(output);
            this.completeInternal(resultAsJson, null, runtimeStatus);
        }

        private void completeInternal(@Nullable String rawOutput, @Nullable FailureDetails failureDetails, OrchestratorService.OrchestrationStatus runtimeStatus) {
            Helpers.throwIfOrchestratorComplete(this.isComplete);
            int id = this.sequenceNumber++;
            OrchestratorService.CompleteOrchestrationAction.Builder builder = OrchestratorService.CompleteOrchestrationAction.newBuilder();
            builder.setOrchestrationStatus(runtimeStatus);
            if (rawOutput != null) {
                builder.setResult(StringValue.of((String)rawOutput));
            }
            if (failureDetails != null) {
                builder.setFailureDetails(failureDetails.toProto());
            }
            if (this.continuedAsNew && this.preserveUnprocessedEvents) {
                for (OrchestratorService.HistoryEvent e : this.unprocessedEvents) {
                    builder.addCarryoverEvents(e);
                }
            }
            if (!this.isReplaying) {
                // empty if block
            }
            OrchestratorService.OrchestratorAction action = OrchestratorService.OrchestratorAction.newBuilder().setId(id).setCompleteOrchestration(builder.build()).build();
            this.pendingActions.put(id, action);
            this.isComplete = true;
        }

        private boolean waitingForEvents() {
            return this.outstandingEvents.size() > 0;
        }

        private boolean processNextEvent() {
            return this.historyEventPlayer.moveNext();
        }

        private void processEvent(OrchestratorService.HistoryEvent e) {
            boolean overrideSuspension;
            boolean bl = overrideSuspension = e.getEventTypeCase() == OrchestratorService.HistoryEvent.EventTypeCase.EXECUTIONRESUMED || e.getEventTypeCase() == OrchestratorService.HistoryEvent.EventTypeCase.EXECUTIONTERMINATED;
            if (this.isSuspended && !overrideSuspension) {
                this.handleEventWhileSuspended(e);
            } else {
                switch (e.getEventTypeCase()) {
                    case ORCHESTRATORSTARTED: {
                        Instant instant = DataConverter.getInstantFromTimestamp(e.getTimestamp());
                        this.setCurrentInstant(instant);
                        break;
                    }
                    case ORCHESTRATORCOMPLETED: {
                        break;
                    }
                    case EXECUTIONSTARTED: {
                        OrchestratorService.ExecutionStartedEvent startedEvent = e.getExecutionStarted();
                        String name = startedEvent.getName();
                        this.setName(name);
                        String instanceId = startedEvent.getOrchestrationInstance().getInstanceId();
                        this.setInstanceId(instanceId);
                        String input = startedEvent.getInput().getValue();
                        this.setInput(input);
                        TaskOrchestrationFactory factory = (TaskOrchestrationFactory)TaskOrchestrationExecutor.this.orchestrationFactories.get(name);
                        if (factory == null) {
                            factory = (TaskOrchestrationFactory)TaskOrchestrationExecutor.this.orchestrationFactories.get("*");
                        }
                        TaskOrchestration orchestrator = factory.create();
                        orchestrator.run(this);
                        break;
                    }
                    case EXECUTIONTERMINATED: {
                        this.handleExecutionTerminated(e);
                        break;
                    }
                    case TASKSCHEDULED: {
                        this.handleTaskScheduled(e);
                        break;
                    }
                    case TASKCOMPLETED: {
                        this.handleTaskCompleted(e);
                        break;
                    }
                    case TASKFAILED: {
                        this.handleTaskFailed(e);
                        break;
                    }
                    case TIMERCREATED: {
                        this.handleTimerCreated(e);
                        break;
                    }
                    case TIMERFIRED: {
                        this.handleTimerFired(e);
                        break;
                    }
                    case SUBORCHESTRATIONINSTANCECREATED: {
                        this.handleSubOrchestrationCreated(e);
                        break;
                    }
                    case SUBORCHESTRATIONINSTANCECOMPLETED: {
                        this.handleSubOrchestrationCompleted(e);
                        break;
                    }
                    case SUBORCHESTRATIONINSTANCEFAILED: {
                        this.handleSubOrchestrationFailed(e);
                        break;
                    }
                    case EVENTRAISED: {
                        this.handleEventRaised(e);
                        break;
                    }
                    case EXECUTIONSUSPENDED: {
                        this.handleExecutionSuspended(e);
                        break;
                    }
                    case EXECUTIONRESUMED: {
                        this.handleExecutionResumed(e);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Don't know how to handle history type " + (Object)((Object)e.getEventTypeCase()));
                    }
                }
            }
        }

        private class CompletableTask<V>
        extends Task<V> {
            public CompletableTask() {
                this(new CompletableFuture());
            }

            CompletableTask(CompletableFuture<V> future) {
                super(future);
            }

            @Override
            public V await() {
                do {
                    if (!this.future.isDone()) continue;
                    try {
                        return (V)this.future.get();
                    }
                    catch (ExecutionException e) {
                        this.handleException(e.getCause());
                    }
                    catch (Exception e) {
                        this.handleException(e);
                    }
                } while (ContextImplTask.this.processNextEvent());
                throw new OrchestratorBlockedException("The orchestrator is blocked and waiting for new inputs. This Throwable should never be caught by user code.");
            }

            protected void handleException(Throwable e) {
                if (e instanceof TaskFailedException) {
                    throw (TaskFailedException)e;
                }
                if (e instanceof CompositeTaskFailedException) {
                    throw (CompositeTaskFailedException)e;
                }
                throw new RuntimeException("Unexpected failure in the task execution", e);
            }

            @Override
            public boolean isDone() {
                return this.future.isDone();
            }

            public boolean complete(V value) {
                return this.future.complete(value);
            }

            private boolean cancel() {
                return this.future.cancel(true);
            }

            public boolean completeExceptionally(Throwable ex) {
                return this.future.completeExceptionally(ex);
            }
        }

        private class RetriableTask<V>
        extends CompletableTask<V> {
            private final RetryPolicy policy;
            private final RetryHandler handler;
            private final TaskOrchestrationContext context;
            private final Instant firstAttempt;
            private final TaskFactory<V> taskFactory;
            private int attemptNumber;
            private FailureDetails lastFailure;
            private Duration totalRetryTime;

            public RetriableTask(TaskOrchestrationContext context, TaskFactory<V> taskFactory, RetryPolicy policy) {
                this(context, taskFactory, policy, null);
            }

            public RetriableTask(TaskOrchestrationContext context, TaskFactory<V> taskFactory, RetryHandler handler) {
                this(context, taskFactory, null, handler);
            }

            private RetriableTask(TaskOrchestrationContext context, @Nullable TaskFactory<V> taskFactory, @Nullable RetryPolicy retryPolicy, RetryHandler retryHandler) {
                super(new CompletableFuture());
                this.context = context;
                this.taskFactory = taskFactory;
                this.policy = retryPolicy;
                this.handler = retryHandler;
                this.firstAttempt = context.getCurrentInstant();
                this.totalRetryTime = Duration.ZERO;
            }

            @Override
            public V await() {
                Instant startTime = this.context.getCurrentInstant();
                while (true) {
                    Task<V> currentTask = this.taskFactory.create();
                    ++this.attemptNumber;
                    try {
                        return currentTask.await();
                    }
                    catch (TaskFailedException ex) {
                        this.lastFailure = ex.getErrorDetails();
                        if (!this.shouldRetry()) {
                            throw ex;
                        }
                        if (this.attemptNumber == Integer.MAX_VALUE) {
                            throw ex;
                        }
                        Duration delay = this.getNextDelay();
                        if (!delay.isZero() && !delay.isNegative()) {
                            this.context.createTimer(delay).await();
                        }
                        this.totalRetryTime = Duration.between(startTime, this.context.getCurrentInstant());
                        continue;
                    }
                    break;
                }
            }

            private boolean shouldRetry() {
                if (this.lastFailure.isNonRetriable()) {
                    return false;
                }
                if (this.policy != null) {
                    return this.shouldRetryBasedOnPolicy();
                }
                if (this.handler != null) {
                    RetryContext retryContext = new RetryContext(this.context, this.attemptNumber, this.lastFailure, this.totalRetryTime);
                    return this.handler.handle(retryContext);
                }
                return false;
            }

            private boolean shouldRetryBasedOnPolicy() {
                if (this.attemptNumber >= this.policy.getMaxNumberOfAttempts()) {
                    return false;
                }
                Duration retryTimeout = this.policy.getRetryTimeout();
                if (retryTimeout.compareTo(Duration.ZERO) > 0) {
                    Instant retryExpiration = this.firstAttempt.plus(retryTimeout);
                    if (this.context.getCurrentInstant().compareTo(retryExpiration) >= 0) {
                        return false;
                    }
                }
                return true;
            }

            private Duration getNextDelay() {
                if (this.policy != null) {
                    long nextDelayInMillis;
                    long maxDelayInMillis = this.policy.getMaxRetryInterval().toMillis();
                    try {
                        nextDelayInMillis = Math.multiplyExact(this.policy.getFirstRetryInterval().toMillis(), (long)Helpers.powExact(this.policy.getBackoffCoefficient(), this.attemptNumber));
                    }
                    catch (ArithmeticException overflowException) {
                        if (maxDelayInMillis > 0L) {
                            return this.policy.getMaxRetryInterval();
                        }
                        throw new ArithmeticException("The retry policy calculation resulted in an arithmetic overflow and no max retry interval was configured.");
                    }
                    if (nextDelayInMillis > maxDelayInMillis && maxDelayInMillis > 0L) {
                        return this.policy.getMaxRetryInterval();
                    }
                    return Duration.ofMillis(nextDelayInMillis);
                }
                return Duration.ZERO;
            }
        }

        private class ExternalEventTask<V>
        extends CompletableTask<V> {
            private final String eventName;
            private final Duration timeout;
            private final int taskId;

            public ExternalEventTask(String eventName, int taskId, Duration timeout) {
                this.eventName = eventName;
                this.taskId = taskId;
                this.timeout = timeout;
            }

            @Override
            protected void handleException(Throwable e) {
                if (e instanceof CancellationException) {
                    String message = String.format("Timeout of %s expired while waiting for an event named '%s' (ID = %d).", this.timeout, this.eventName, this.taskId);
                    throw new TaskCanceledException(message, this.eventName, this.taskId);
                }
                super.handleException(e);
            }
        }

        private class OrchestrationHistoryIterator {
            private final List<OrchestratorService.HistoryEvent> pastEvents;
            private final List<OrchestratorService.HistoryEvent> newEvents;
            private List<OrchestratorService.HistoryEvent> currentHistoryList;
            private int currentHistoryIndex;

            public OrchestrationHistoryIterator(List<OrchestratorService.HistoryEvent> pastEvents, List<OrchestratorService.HistoryEvent> newEvents) {
                this.pastEvents = pastEvents;
                this.newEvents = newEvents;
                this.currentHistoryList = pastEvents;
            }

            public boolean moveNext() {
                if (this.currentHistoryList == this.pastEvents && this.currentHistoryIndex >= this.pastEvents.size()) {
                    this.currentHistoryList = this.newEvents;
                    this.currentHistoryIndex = 0;
                    ContextImplTask.this.setDoneReplaying();
                }
                if (this.currentHistoryList == this.newEvents && this.currentHistoryIndex >= this.newEvents.size()) {
                    return false;
                }
                OrchestratorService.HistoryEvent next = this.currentHistoryList.get(this.currentHistoryIndex++);
                ContextImplTask.this.processEvent(next);
                return true;
            }
        }

        private class TaskRecord<V> {
            private final CompletableTask<V> task;
            private final String taskName;
            private final Class<V> dataType;

            public TaskRecord(CompletableTask<V> task, String taskName, Class<V> dataType) {
                this.task = task;
                this.taskName = taskName;
                this.dataType = dataType;
            }

            public CompletableTask<V> getTask() {
                return this.task;
            }

            public String getTaskName() {
                return this.taskName;
            }

            public Class<V> getDataType() {
                return this.dataType;
            }
        }
    }
}

