/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.durabletask;

import com.microsoft.durabletask.NewOrchestrationInstanceOptions;
import com.microsoft.durabletask.OrchestrationMetadata;
import com.microsoft.durabletask.OrchestrationStatusQuery;
import com.microsoft.durabletask.OrchestrationStatusQueryResult;
import com.microsoft.durabletask.PurgeInstanceCriteria;
import com.microsoft.durabletask.PurgeResult;
import java.time.Duration;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

public abstract class DurableTaskClient
implements AutoCloseable {
    @Override
    public void close() {
    }

    public String scheduleNewOrchestrationInstance(String orchestratorName) {
        return this.scheduleNewOrchestrationInstance(orchestratorName, null, null);
    }

    public String scheduleNewOrchestrationInstance(String orchestratorName, Object input) {
        return this.scheduleNewOrchestrationInstance(orchestratorName, input, null);
    }

    public String scheduleNewOrchestrationInstance(String orchestratorName, Object input, String instanceId) {
        NewOrchestrationInstanceOptions options = new NewOrchestrationInstanceOptions().setInput(input).setInstanceId(instanceId);
        return this.scheduleNewOrchestrationInstance(orchestratorName, options);
    }

    public abstract String scheduleNewOrchestrationInstance(String var1, NewOrchestrationInstanceOptions var2);

    public void raiseEvent(String instanceId, String eventName) {
        this.raiseEvent(instanceId, eventName, null);
    }

    public abstract void raiseEvent(String var1, String var2, @Nullable Object var3);

    @Nullable
    public abstract OrchestrationMetadata getInstanceMetadata(String var1, boolean var2);

    @Nullable
    public OrchestrationMetadata waitForInstanceStart(String instanceId, Duration timeout) throws TimeoutException {
        return this.waitForInstanceStart(instanceId, timeout, false);
    }

    @Nullable
    public abstract OrchestrationMetadata waitForInstanceStart(String var1, Duration var2, boolean var3) throws TimeoutException;

    @Nullable
    public abstract OrchestrationMetadata waitForInstanceCompletion(String var1, Duration var2, boolean var3) throws TimeoutException;

    public abstract void terminate(String var1, @Nullable Object var2);

    public abstract OrchestrationStatusQueryResult queryInstances(OrchestrationStatusQuery var1);

    public abstract void createTaskHub(boolean var1);

    public abstract void deleteTaskHub();

    public abstract PurgeResult purgeInstance(String var1);

    public abstract PurgeResult purgeInstances(PurgeInstanceCriteria var1) throws TimeoutException;

    public abstract String restartInstance(String var1, boolean var2);

    public void suspendInstance(String instanceId) {
        this.suspendInstance(instanceId, null);
    }

    public void resumeInstance(String instanceId) {
        this.resumeInstance(instanceId, null);
    }

    public abstract void suspendInstance(String var1, @Nullable String var2);

    public abstract void resumeInstance(String var1, @Nullable String var2);
}

