/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.durabletask;

import com.microsoft.durabletask.DataConverter;
import com.microsoft.durabletask.DurableTaskGrpcWorker;
import com.microsoft.durabletask.TaskActivityFactory;
import com.microsoft.durabletask.TaskOrchestrationFactory;
import io.grpc.Channel;
import java.time.Duration;
import java.util.HashMap;

public final class DurableTaskGrpcWorkerBuilder {
    final HashMap<String, TaskOrchestrationFactory> orchestrationFactories = new HashMap();
    final HashMap<String, TaskActivityFactory> activityFactories = new HashMap();
    int port;
    Channel channel;
    DataConverter dataConverter;
    Duration maximumTimerInterval;

    public DurableTaskGrpcWorkerBuilder addOrchestration(TaskOrchestrationFactory factory) {
        String key = factory.getName();
        if (key == null || key.length() == 0) {
            throw new IllegalArgumentException("A non-empty task orchestration name is required.");
        }
        if (this.orchestrationFactories.containsKey(key)) {
            throw new IllegalArgumentException(String.format("A task orchestration factory named %s is already registered.", key));
        }
        this.orchestrationFactories.put(key, factory);
        return this;
    }

    public DurableTaskGrpcWorkerBuilder addActivity(TaskActivityFactory factory) {
        String key = factory.getName();
        if (key == null || key.length() == 0) {
            throw new IllegalArgumentException("A non-empty task activity name is required.");
        }
        if (this.activityFactories.containsKey(key)) {
            throw new IllegalArgumentException(String.format("A task activity factory named %s is already registered.", key));
        }
        this.activityFactories.put(key, factory);
        return this;
    }

    public DurableTaskGrpcWorkerBuilder grpcChannel(Channel channel) {
        this.channel = channel;
        return this;
    }

    public DurableTaskGrpcWorkerBuilder port(int port) {
        this.port = port;
        return this;
    }

    public DurableTaskGrpcWorkerBuilder dataConverter(DataConverter dataConverter) {
        this.dataConverter = dataConverter;
        return this;
    }

    public DurableTaskGrpcWorkerBuilder maximumTimerInterval(Duration maximumTimerInterval) {
        this.maximumTimerInterval = maximumTimerInterval;
        return this;
    }

    public DurableTaskGrpcWorker build() {
        return new DurableTaskGrpcWorker(this);
    }
}

