/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.Date;
import microsoft.exchange.webservices.data.BodyType;
import microsoft.exchange.webservices.data.ComplexProperty;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.Item;
import microsoft.exchange.webservices.data.PropertyDefinitionBase;
import microsoft.exchange.webservices.data.ServiceValidationException;
import microsoft.exchange.webservices.data.ServiceVersionException;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.XmlNamespace;

public abstract class Attachment
extends ComplexProperty {
    private Item owner;
    private String id;
    private String name;
    private String contentType;
    private String contentId;
    private String contentLocation;
    private int size;
    private Date lastModifiedTime;
    private boolean isInline;

    protected Attachment(Item owner) {
        this.owner = owner;
    }

    protected void throwIfThisIsNotNew() {
        if (!this.isNew()) {
            throw new UnsupportedOperationException(Strings.AttachmentCannotBeUpdated);
        }
    }

    @Override
    protected <T> boolean canSetFieldValue(T field, T value) {
        this.throwIfThisIsNotNew();
        return super.canSetFieldValue(field, value);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        if (this.canSetFieldValue(this.name, value)) {
            this.name = value;
            this.changed();
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String value) {
        if (this.canSetFieldValue(this.contentType, value)) {
            this.contentType = value;
            this.changed();
        }
    }

    public String getContentId() {
        return this.contentId;
    }

    public void setContentId(String value) {
        if (this.canSetFieldValue(this.contentId, value)) {
            this.contentId = value;
            this.changed();
        }
    }

    public String getContentLocation() {
        return this.contentLocation;
    }

    public void setContentLocation(String value) {
        if (this.canSetFieldValue(this.contentLocation, value)) {
            this.contentLocation = value;
            this.changed();
        }
    }

    public int getSize() throws ServiceVersionException {
        EwsUtilities.validatePropertyVersion(this.getOwner().getService(), ExchangeVersion.Exchange2010, "Size");
        return this.size;
    }

    public Date getLastModifiedTime() throws ServiceVersionException {
        EwsUtilities.validatePropertyVersion(this.getOwner().getService(), ExchangeVersion.Exchange2010, "LastModifiedTime");
        return this.lastModifiedTime;
    }

    public boolean getIsInline() throws ServiceVersionException {
        EwsUtilities.validatePropertyVersion(this.getOwner().getService(), ExchangeVersion.Exchange2010, "IsInline");
        return this.isInline;
    }

    public void setIsInline(boolean value) throws ServiceVersionException {
        EwsUtilities.validatePropertyVersion(this.getOwner().getService(), ExchangeVersion.Exchange2010, "IsInline");
        if (this.canSetFieldValue(this.isInline, value)) {
            this.isInline = value;
            this.changed();
        }
    }

    protected boolean isNew() {
        return this.getId() == null || this.getId().isEmpty();
    }

    protected Item getOwner() {
        return this.owner;
    }

    abstract String getXmlElementName();

    @Override
    protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        try {
            if (reader.getLocalName().equalsIgnoreCase("AttachmentId")) {
                String rootItemChangeKey;
                try {
                    this.id = reader.readAttributeValue("Id");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
                if (this.getOwner() != null && null != (rootItemChangeKey = reader.readAttributeValue("RootItemChangeKey")) && !rootItemChangeKey.isEmpty()) {
                    this.getOwner().getRootItemId().setChangeKey(rootItemChangeKey);
                }
                reader.readEndElementIfNecessary(XmlNamespace.Types, "AttachmentId");
                return true;
            }
            if (reader.getLocalName().equalsIgnoreCase("Name")) {
                this.name = reader.readElementValue();
                return true;
            }
            if (reader.getLocalName().equalsIgnoreCase("ContentType")) {
                this.contentType = reader.readElementValue();
                return true;
            }
            if (reader.getLocalName().equalsIgnoreCase("ContentId")) {
                this.contentId = reader.readElementValue();
                return true;
            }
            if (reader.getLocalName().equalsIgnoreCase("ContentLocation")) {
                this.contentLocation = reader.readElementValue();
                return true;
            }
            if (reader.getLocalName().equalsIgnoreCase("Size")) {
                this.size = reader.readElementValue(Integer.class);
                return true;
            }
            if (reader.getLocalName().equalsIgnoreCase("LastModifiedTime")) {
                this.lastModifiedTime = reader.readElementValueAsDateTime();
                return true;
            }
            if (reader.getLocalName().equalsIgnoreCase("IsInline")) {
                this.isInline = reader.readElementValue(Boolean.class);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        writer.writeElementValue(XmlNamespace.Types, "Name", this.getName());
        writer.writeElementValue(XmlNamespace.Types, "ContentType", this.getContentType());
        writer.writeElementValue(XmlNamespace.Types, "ContentId", this.getContentId());
        writer.writeElementValue(XmlNamespace.Types, "ContentLocation", this.getContentLocation());
        if (writer.getService().getRequestedServerVersion().ordinal() > ExchangeVersion.Exchange2007_SP1.ordinal()) {
            writer.writeElementValue(XmlNamespace.Types, "IsInline", this.getIsInline());
        }
    }

    protected void internalLoad(BodyType bodyType, Iterable<PropertyDefinitionBase> additionalProperties) throws Exception {
        this.getOwner().getService().getAttachment(this, bodyType, additionalProperties);
    }

    void validate(int attachmentIndex) throws ServiceValidationException, Exception {
    }

    public void load() throws Exception {
        this.internalLoad(null, null);
    }
}

