/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.GetUserOofSettingsResponse;
import microsoft.exchange.webservices.data.OofExternalAudience;
import microsoft.exchange.webservices.data.OofSettings;
import microsoft.exchange.webservices.data.ServiceError;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.SimpleServiceRequestBase;
import microsoft.exchange.webservices.data.XmlNamespace;

final class GetUserOofSettingsRequest
extends SimpleServiceRequestBase {
    private String smtpAddress;

    @Override
    protected String getXmlElementName() {
        return "GetUserOofSettingsRequest";
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParam(this.getSmtpAddress(), "SmtpAddress");
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        writer.writeStartElement(XmlNamespace.Types, "Mailbox");
        writer.writeElementValue(XmlNamespace.Types, "Address", this.getSmtpAddress());
        writer.writeEndElement();
    }

    @Override
    protected String getResponseXmlElementName() {
        return "GetUserOofSettingsResponse";
    }

    @Override
    protected Object parseResponse(EwsServiceXmlReader reader) throws Exception {
        GetUserOofSettingsResponse serviceResponse = new GetUserOofSettingsResponse();
        serviceResponse.loadFromXml(reader, "ResponseMessage");
        if (serviceResponse.getErrorCode() == ServiceError.NoError) {
            reader.readStartElement(XmlNamespace.Types, "OofSettings");
            serviceResponse.setOofSettings(new OofSettings());
            serviceResponse.getOofSettings().loadFromXml(reader, reader.getLocalName());
            serviceResponse.getOofSettings().setAllowExternalOof(reader.readElementValue(OofExternalAudience.class, XmlNamespace.Messages, "AllowExternalOof"));
        }
        return serviceResponse;
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    protected GetUserOofSettingsRequest(ExchangeService service) throws Exception {
        super(service);
    }

    protected GetUserOofSettingsResponse execute() throws Exception {
        GetUserOofSettingsResponse serviceResponse = (GetUserOofSettingsResponse)this.internalExecute();
        serviceResponse.throwIfNecessary();
        return serviceResponse;
    }

    protected String getSmtpAddress() {
        return this.smtpAddress;
    }

    protected void setSmtpAddress(String smtpAddress) {
        this.smtpAddress = smtpAddress;
    }
}

