/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.HangingServiceRequestBase;
import microsoft.exchange.webservices.data.TraceFlags;

class HangingTraceStream
extends InputStream {
    private InputStream underlyingStream;
    private ExchangeService service;
    private ByteArrayOutputStream responseCopy;

    protected HangingTraceStream(InputStream stream, ExchangeService service) {
        this.underlyingStream = stream;
        this.service = service;
        if (this.service.isTraceEnabledFor(TraceFlags.EwsResponse)) {
            this.responseCopy = new ByteArrayOutputStream();
        }
    }

    public boolean getCanRead() {
        return true;
    }

    public boolean getCanSeek() {
        return false;
    }

    public boolean getCanWrite() {
        return false;
    }

    @Override
    public int read(byte[] buffer, int offset, int count) throws IOException {
        count = 4096;
        int retVal = this.underlyingStream.read(buffer, offset, count);
        if (HangingServiceRequestBase.LogAllWireBytes) {
            String readString = new String(buffer, offset, count, "UTF-8");
            String logMessage = String.format("HangingTraceStream ID [%d] returned %d bytes. Bytes returned: [%s]", this.hashCode(), retVal, readString);
            try {
                this.service.traceMessage(TraceFlags.DebugMessage, logMessage);
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
        }
        if (this.responseCopy != null) {
            this.responseCopy.write(buffer, offset, retVal);
        }
        return retVal;
    }

    protected ByteArrayOutputStream GetResponseCopy() {
        return this.responseCopy;
    }

    @Override
    public int read() throws IOException {
        return 0;
    }
}

