/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import microsoft.exchange.webservices.data.AbstractItemIdWrapper;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.Item;
import microsoft.exchange.webservices.data.ItemId;
import microsoft.exchange.webservices.data.ItemIdWrapper;
import microsoft.exchange.webservices.data.ItemWrapper;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.XmlNamespace;

class ItemIdWrapperList
implements Iterable<AbstractItemIdWrapper> {
    private List<AbstractItemIdWrapper> itemIds = new ArrayList<AbstractItemIdWrapper>();

    protected ItemIdWrapperList() {
    }

    protected void add(Item item) throws ServiceLocalException {
        this.itemIds.add(new ItemWrapper(item));
    }

    protected void addRangeItem(Iterable<Item> items) throws ServiceLocalException {
        for (Item item : items) {
            this.add(item);
        }
    }

    protected void addRange(Iterable<ItemId> itemIds) {
        for (ItemId itemId : itemIds) {
            this.add(itemId);
        }
    }

    protected void add(ItemId itemId) {
        this.itemIds.add(new ItemIdWrapper(itemId));
    }

    protected void writeToXml(EwsServiceXmlWriter writer, XmlNamespace ewsNamesapce, String xmlElementName) throws Exception {
        if (this.getCount() > 0) {
            writer.writeStartElement(ewsNamesapce, xmlElementName);
            for (AbstractItemIdWrapper itemIdWrapper : this.itemIds) {
                itemIdWrapper.writeToXml(writer);
            }
            writer.writeEndElement();
        }
    }

    protected int getCount() {
        return this.itemIds.size();
    }

    protected Item getItemIdWrapperList(int i) {
        return this.itemIds.get(i).getItem();
    }

    @Override
    public Iterator<AbstractItemIdWrapper> iterator() {
        return this.itemIds.iterator();
    }
}

