/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.EditorBrowsable;
import microsoft.exchange.webservices.data.EditorBrowsableState;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.Grouping;
import microsoft.exchange.webservices.data.OffsetBasePoint;
import microsoft.exchange.webservices.data.ServiceRequestBase;
import microsoft.exchange.webservices.data.ServiceValidationException;
import microsoft.exchange.webservices.data.ServiceVersionException;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.ViewBase;

@EditorBrowsable(state=EditorBrowsableState.Never)
public abstract class PagedView
extends ViewBase {
    private int pageSize;
    private OffsetBasePoint offsetBasePoint = OffsetBasePoint.Beginning;
    private int offset;

    @Override
    protected void internalWriteViewToXml(EwsServiceXmlWriter writer) throws Exception {
        super.internalWriteViewToXml(writer);
        writer.writeAttributeValue("Offset", this.getOffset());
        writer.writeAttributeValue("BasePoint", (Object)this.getOffsetBasePoint());
    }

    @Override
    protected Integer getMaxEntriesReturned() {
        return this.getPageSize();
    }

    @Override
    protected void internalWriteSearchSettingsToXml(EwsServiceXmlWriter writer, Grouping groupBy) throws XMLStreamException, ServiceXmlSerializationException {
        if (groupBy != null) {
            groupBy.writeToXml(writer);
        }
    }

    @Override
    protected void writeOrderByToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
    }

    @Override
    protected void internalValidate(ServiceRequestBase request) throws ServiceVersionException, ServiceValidationException {
        super.internalValidate(request);
    }

    protected PagedView(int pageSize) {
        this.setPageSize(pageSize);
    }

    protected PagedView(int pageSize, int offset) {
        this(pageSize);
        this.setOffset(offset);
    }

    protected PagedView(int pageSize, int offset, OffsetBasePoint offsetBasePoint) {
        this(pageSize, offset);
        this.setOffsetBasePoint(offsetBasePoint);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        if (pageSize <= 0) {
            throw new IllegalArgumentException(Strings.ValueMustBeGreaterThanZero);
        }
        this.pageSize = pageSize;
    }

    public OffsetBasePoint getOffsetBasePoint() {
        return this.offsetBasePoint;
    }

    public void setOffsetBasePoint(OffsetBasePoint offsetBasePoint) {
        this.offsetBasePoint = offsetBasePoint;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException(Strings.OffsetMustBeGreaterThanZero);
        }
        this.offset = offset;
    }
}

