/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.HashMap;
import java.util.Map;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.FolderIdWrapperList;
import microsoft.exchange.webservices.data.ILazyMember;
import microsoft.exchange.webservices.data.LazyMember;
import microsoft.exchange.webservices.data.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.ResolveNameSearchLocation;
import microsoft.exchange.webservices.data.ResolveNamesResponse;
import microsoft.exchange.webservices.data.ServiceErrorHandling;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.XmlNamespace;

final class ResolveNamesRequest
extends MultiResponseServiceRequest<ResolveNamesResponse> {
    private static LazyMember<Map<ResolveNameSearchLocation, String>> searchScopeMap = new LazyMember<Map<ResolveNameSearchLocation, String>>(new ILazyMember<Map<ResolveNameSearchLocation, String>>(){

        @Override
        public Map<ResolveNameSearchLocation, String> createInstance() {
            HashMap<ResolveNameSearchLocation, String> map = new HashMap<ResolveNameSearchLocation, String>();
            map.put(ResolveNameSearchLocation.DirectoryOnly, "ActiveDirectory");
            map.put(ResolveNameSearchLocation.DirectoryThenContacts, "ActiveDirectoryContacts");
            map.put(ResolveNameSearchLocation.ContactsOnly, "Contacts");
            map.put(ResolveNameSearchLocation.ContactsThenDirectory, "ContactsActiveDirectory");
            return map;
        }
    });
    private String nameToResolve;
    private boolean returnFullContactData;
    private ResolveNameSearchLocation searchLocation;
    private FolderIdWrapperList parentFolderIds = new FolderIdWrapperList();

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateNonBlankStringParam(this.getNameToResolve(), "NameToResolve");
    }

    @Override
    protected ResolveNamesResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new ResolveNamesResponse(service);
    }

    @Override
    protected String getXmlElementName() {
        return "ResolveNames";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "ResolveNamesResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "ResolveNamesResponseMessage";
    }

    protected ResolveNamesRequest(ExchangeService service) throws Exception {
        super(service, ServiceErrorHandling.ThrowOnError);
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return 1;
    }

    @Override
    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        writer.writeAttributeValue("ReturnFullContactData", this.returnFullContactData);
        String searchScope = null;
        if (searchScopeMap.getMember().containsKey((Object)this.searchLocation)) {
            searchScope = searchScopeMap.getMember().get((Object)this.searchLocation);
        }
        EwsUtilities.EwsAssert(searchScope != null && !searchScope.isEmpty(), "ResolveNameRequest.WriteAttributesToXml", "The specified search location cannot be mapped to an EWS search scope.");
        if (!this.getService().getExchange2007CompatibilityMode()) {
            writer.writeAttributeValue("SearchScope", searchScope);
        }
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        this.getParentFolderIds().writeToXml(writer, XmlNamespace.Messages, "ParentFolderIds");
        writer.writeElementValue(XmlNamespace.Messages, "UnresolvedEntry", this.getNameToResolve());
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public String getNameToResolve() {
        return this.nameToResolve;
    }

    public void setNameToResolve(String nameToResolve) {
        this.nameToResolve = nameToResolve;
    }

    public boolean getReturnFullContactData() {
        return this.returnFullContactData;
    }

    public void setReturnFullContactData(boolean returnFullContactData) {
        this.returnFullContactData = returnFullContactData;
    }

    public ResolveNameSearchLocation getSearchLocation() {
        return this.searchLocation;
    }

    public void setSearchLocation(ResolveNameSearchLocation searchLocation) {
        this.searchLocation = searchLocation;
    }

    public FolderIdWrapperList getParentFolderIds() {
        return this.parentFolderIds;
    }
}

