/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.List;
import microsoft.exchange.webservices.data.AffectedTaskOccurrence;
import microsoft.exchange.webservices.data.DeleteMode;
import microsoft.exchange.webservices.data.EditorBrowsable;
import microsoft.exchange.webservices.data.EditorBrowsableState;
import microsoft.exchange.webservices.data.EmailMessage;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.FolderId;
import microsoft.exchange.webservices.data.Item;
import microsoft.exchange.webservices.data.ItemId;
import microsoft.exchange.webservices.data.MessageDisposition;
import microsoft.exchange.webservices.data.PropertySet;
import microsoft.exchange.webservices.data.ResponseObjectSchema;
import microsoft.exchange.webservices.data.SendCancellationsMode;
import microsoft.exchange.webservices.data.ServiceObject;
import microsoft.exchange.webservices.data.ServiceObjectSchema;
import microsoft.exchange.webservices.data.WellKnownFolderName;

@EditorBrowsable(state=EditorBrowsableState.Never)
public abstract class ResponseObject<TMessage extends EmailMessage>
extends ServiceObject {
    private Item referenceItem;

    protected ResponseObject(Item referenceItem) throws Exception {
        super(referenceItem.getService());
        EwsUtilities.EwsAssert(referenceItem != null, "ResponseObject.ctor", "referenceItem is null");
        referenceItem.throwIfThisIsNew();
        this.referenceItem = referenceItem;
    }

    @Override
    protected ServiceObjectSchema getSchema() {
        return ResponseObjectSchema.Instance;
    }

    @Override
    protected void internalLoad(PropertySet propertySet) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void internalDelete(DeleteMode deleteMode, SendCancellationsMode sendCancellationsMode, AffectedTaskOccurrence affectedTaskOccurrences) {
        throw new UnsupportedOperationException();
    }

    protected List<Item> internalCreate(FolderId destinationFolderId, MessageDisposition messageDisposition) throws Exception {
        ((ItemId)this.getPropertyBag().getObjectFromPropertyDefinition(ResponseObjectSchema.ReferenceItemId)).assign(this.referenceItem.getId());
        return this.getService().internalCreateResponseObject(this, destinationFolderId, messageDisposition);
    }

    public TMessage save(FolderId destinationFolderId) throws Exception {
        EwsUtilities.validateParam(destinationFolderId, "destinationFolderId");
        return (TMessage)((EmailMessage)this.internalCreate(destinationFolderId, MessageDisposition.SaveOnly).get(0));
    }

    public TMessage save(WellKnownFolderName destinationFolderName) throws Exception {
        return (TMessage)((EmailMessage)this.internalCreate(new FolderId(destinationFolderName), MessageDisposition.SaveOnly).get(0));
    }

    public TMessage save() throws Exception {
        return (TMessage)((EmailMessage)this.internalCreate(null, MessageDisposition.SaveOnly).get(0));
    }

    public void send() throws Exception {
        this.internalCreate(null, MessageDisposition.SendOnly);
    }

    public void sendAndSaveCopy(FolderId destinationFolderId) throws Exception {
        EwsUtilities.validateParam(destinationFolderId, "destinationFolderId");
        this.internalCreate(destinationFolderId, MessageDisposition.SendAndSaveCopy);
    }

    public void sendAndSaveCopy(WellKnownFolderName destinationFolderName) throws Exception {
        this.internalCreate(new FolderId(destinationFolderName), MessageDisposition.SendAndSaveCopy);
    }

    public void sendAndSaveCopy() throws Exception {
        this.internalCreate(null, MessageDisposition.SendAndSaveCopy);
    }
}

