/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.EWSHttpException;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeServerInfo;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.HttpErrorException;
import microsoft.exchange.webservices.data.HttpWebRequest;
import microsoft.exchange.webservices.data.OutParam;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceRequestException;
import microsoft.exchange.webservices.data.ServiceResponse;
import microsoft.exchange.webservices.data.ServiceResponseException;
import microsoft.exchange.webservices.data.ServiceValidationException;
import microsoft.exchange.webservices.data.ServiceVersionException;
import microsoft.exchange.webservices.data.ServiceXmlDeserializationException;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.SoapFaultDetails;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.TraceFlags;
import microsoft.exchange.webservices.data.XMLNodeType;
import microsoft.exchange.webservices.data.XmlException;
import microsoft.exchange.webservices.data.XmlNamespace;

abstract class ServiceRequestBase {
    private ExchangeService service;

    protected abstract String getXmlElementName();

    protected abstract String getResponseXmlElementName();

    protected abstract ExchangeVersion getMinimumRequiredServerVersion();

    protected abstract void writeElementsToXml(EwsServiceXmlWriter var1) throws XMLStreamException, ServiceXmlSerializationException, ServiceLocalException, InstantiationException, IllegalAccessException, ServiceValidationException, Exception;

    protected abstract Object parseResponse(EwsServiceXmlReader var1) throws ServiceXmlDeserializationException, XMLStreamException, InstantiationException, IllegalAccessException, ServiceLocalException, ServiceResponseException, IndexOutOfBoundsException, Exception;

    protected void validate() throws ServiceLocalException, Exception {
        this.service.validate();
    }

    protected void writeBodyToXml(EwsServiceXmlWriter writer) throws Exception {
        writer.writeStartElement(XmlNamespace.Messages, this.getXmlElementName());
        this.writeAttributesToXml(writer);
        this.writeElementsToXml(writer);
        writer.writeEndElement();
    }

    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
    }

    protected ServiceRequestBase(ExchangeService service) throws ServiceVersionException {
        this.service = service;
        this.throwIfNotSupportedByRequestedServerVersion();
    }

    protected ExchangeService getService() {
        return this.service;
    }

    protected void throwIfNotSupportedByRequestedServerVersion() throws ServiceVersionException {
        if (this.service.getRequestedServerVersion().ordinal() < this.getMinimumRequiredServerVersion().ordinal()) {
            throw new ServiceVersionException(String.format(Strings.RequestIncompatibleWithRequestVersion, new Object[]{this.getXmlElementName(), this.getMinimumRequiredServerVersion()}));
        }
    }

    protected void writeToXml(EwsServiceXmlWriter writer) throws Exception {
        writer.writeStartDocument();
        writer.writeStartElement(XmlNamespace.Soap, "Envelope");
        writer.writeAttributeValue("xmlns", EwsUtilities.getNamespacePrefix(XmlNamespace.Soap), (Object)EwsUtilities.getNamespaceUri(XmlNamespace.Soap));
        writer.writeAttributeValue("xmlns", "xsi", (Object)"http://www.w3.org/2001/XMLSchema-instance");
        writer.writeAttributeValue("xmlns", "m", (Object)"http://schemas.microsoft.com/exchange/services/2006/messages");
        writer.writeAttributeValue("xmlns", "t", (Object)"http://schemas.microsoft.com/exchange/services/2006/types");
        writer.writeStartElement(XmlNamespace.Soap, "Header");
        if (this.service.getCredentials() != null) {
            this.service.getCredentials().emitExtraSoapHeaderNamespaceAliases(writer.getInternalWriter());
        }
        writer.writeStartElement(XmlNamespace.Types, "RequestServerVersion");
        writer.writeAttributeValue("Version", this.getRequestedServiceVersionString());
        writer.writeEndElement();
        if (this.service.getPreferredCulture() != null) {
            writer.writeElementValue(XmlNamespace.Types, "MailboxCulture", this.service.getPreferredCulture().getDisplayName());
        }
        if (this.service.getImpersonatedUserId() != null) {
            this.service.getImpersonatedUserId().writeToXml(writer);
        }
        if (this.service.getCredentials() != null) {
            this.service.getCredentials().serializeExtraSoapHeaders(writer.getInternalWriter(), this.getXmlElementName());
        }
        this.service.doOnSerializeCustomSoapHeaders(writer.getInternalWriter());
        writer.writeEndElement();
        writer.writeStartElement(XmlNamespace.Soap, "Body");
        this.writeBodyToXml(writer);
        writer.writeEndElement();
        writer.writeEndElement();
        writer.flush();
    }

    private String getRequestedServiceVersionString() {
        return this.service.getRequestedServerVersion().toString();
    }

    protected HttpWebRequest emit(OutParam<HttpWebRequest> request) throws Exception {
        request.setParam((Object)this.getService().prepareHttpWebRequest());
        this.getService().traceHttpRequestHeaders(TraceFlags.EwsRequestHttpHeaders, (HttpWebRequest)request.getParam());
        if (this.service.isTraceEnabledFor(TraceFlags.EwsRequest)) {
            ByteArrayOutputStream memoryStream = new ByteArrayOutputStream();
            EwsServiceXmlWriter writer = new EwsServiceXmlWriter(this.service, memoryStream);
            this.writeToXml(writer);
            this.service.traceXml(TraceFlags.EwsRequest, memoryStream);
            OutputStream urlOutStream = ((HttpWebRequest)request.getParam()).getOutputStream();
            memoryStream.writeTo(urlOutStream);
            urlOutStream.flush();
            urlOutStream.close();
            writer.dispose();
            memoryStream.close();
        } else {
            OutputStream urlOutStream = ((HttpWebRequest)request.getParam()).getOutputStream();
            EwsServiceXmlWriter writer = new EwsServiceXmlWriter(this.service, urlOutStream);
            this.writeToXml(writer);
            urlOutStream.flush();
            urlOutStream.close();
            writer.dispose();
        }
        ((HttpWebRequest)request.getParam()).executeRequest();
        if (((HttpWebRequest)request.getParam()).getResponseCode() >= 400) {
            throw new HttpErrorException("The remote server returned an error: (" + ((HttpWebRequest)request.getParam()).getResponseCode() + ")" + ((HttpWebRequest)request.getParam()).getResponseText(), ((HttpWebRequest)request.getParam()).getResponseCode());
        }
        return (HttpWebRequest)request.getParam();
    }

    protected static InputStream getResponseStream(HttpWebRequest request) throws IOException, EWSHttpException {
        String contentEncoding = "";
        if (null != request.getContentEncoding()) {
            contentEncoding = request.getContentEncoding().toLowerCase();
        }
        InputStream responseStream = contentEncoding.contains("gzip") ? new GZIPInputStream(request.getInputStream()) : (contentEncoding.contains("deflate") ? new InflaterInputStream(request.getInputStream()) : request.getInputStream());
        return responseStream;
    }

    protected void traceResponse(HttpWebRequest request, ByteArrayOutputStream memoryStream) throws XMLStreamException, IOException, EWSHttpException {
        this.service.traceHttpResponseHeaders(TraceFlags.EwsResponseHttpHeaders, request);
        String contentType = request.getResponseContentType();
        if (!this.isNullOrEmpty(contentType) && (contentType.startsWith("text/") || contentType.startsWith("application/soap"))) {
            this.service.traceXml(TraceFlags.EwsResponse, memoryStream);
        } else {
            this.service.traceMessage(TraceFlags.EwsResponse, "Non-textual response");
        }
    }

    private static InputStream getResponseErrorStream(HttpWebRequest request) throws EWSHttpException, IOException {
        String contentEncoding = "";
        if (null != request.getContentEncoding()) {
            contentEncoding = request.getContentEncoding().toLowerCase();
        }
        InputStream responseStream = contentEncoding.contains("gzip") ? new GZIPInputStream(request.getErrorStream()) : (contentEncoding.contains("deflate") ? new InflaterInputStream(request.getErrorStream()) : request.getErrorStream());
        return responseStream;
    }

    protected Object readResponse(EwsServiceXmlReader ewsXmlReader) throws Exception {
        this.readPreamble(ewsXmlReader);
        ewsXmlReader.readStartElement(XmlNamespace.Soap, "Envelope");
        this.readSoapHeader(ewsXmlReader);
        ewsXmlReader.readStartElement(XmlNamespace.Soap, "Body");
        ewsXmlReader.readStartElement(XmlNamespace.Messages, this.getResponseXmlElementName());
        Object serviceResponse = this.parseResponse(ewsXmlReader);
        ewsXmlReader.readEndElementIfNecessary(XmlNamespace.Messages, this.getResponseXmlElementName());
        ewsXmlReader.readEndElement(XmlNamespace.Soap, "Body");
        ewsXmlReader.readEndElement(XmlNamespace.Soap, "Envelope");
        return serviceResponse;
    }

    protected void readPreamble(EwsServiceXmlReader ewsXmlReader) throws Exception {
        this.readXmlDeclaration(ewsXmlReader);
    }

    private void readSoapHeader(EwsServiceXmlReader reader) throws Exception {
        reader.readStartElement(XmlNamespace.Soap, "Header");
        do {
            reader.read();
            if (!reader.isStartElement(XmlNamespace.Types, "ServerVersionInfo")) continue;
            this.service.setServerInfo(ExchangeServerInfo.parse(reader));
        } while (!reader.isEndElement(XmlNamespace.Soap, "Header"));
    }

    private void processWebException(Exception webException, HttpWebRequest req) throws Exception {
        SoapFaultDetails soapFaultDetails = null;
        if (null != req) {
            if (500 == req.getResponseCode()) {
                if (this.service.isTraceEnabledFor(TraceFlags.EwsResponse)) {
                    int data;
                    ByteArrayOutputStream memoryStream = new ByteArrayOutputStream();
                    InputStream serviceResponseStream = ServiceRequestBase.getResponseErrorStream(req);
                    while (-1 != (data = serviceResponseStream.read())) {
                        memoryStream.write(data);
                    }
                    memoryStream.flush();
                    serviceResponseStream.close();
                    this.traceResponse(req, memoryStream);
                    ByteArrayInputStream memoryStreamIn = new ByteArrayInputStream(memoryStream.toByteArray());
                    EwsServiceXmlReader reader = new EwsServiceXmlReader(memoryStreamIn, this.service);
                    soapFaultDetails = this.readSoapFault(reader);
                    memoryStream.close();
                } else {
                    InputStream serviceResponseStream = ServiceRequestBase.getResponseStream(req);
                    EwsServiceXmlReader reader = new EwsServiceXmlReader(serviceResponseStream, this.service);
                    soapFaultDetails = this.readSoapFault(reader);
                    serviceResponseStream.close();
                }
                if (soapFaultDetails != null) {
                    switch (soapFaultDetails.getResponseCode()) {
                        case ErrorInvalidServerVersion: {
                            throw new ServiceVersionException(Strings.ServerVersionNotSupported);
                        }
                        case ErrorSchemaValidation: {
                            if (this.service.getServerInfo() == null || this.service.getServerInfo().getMajorVersion() != 8 || this.service.getServerInfo().getMinorVersion() != 0) break;
                            throw new ServiceVersionException(Strings.ServerVersionNotSupported);
                        }
                        case ErrorIncorrectSchemaVersion: {
                            EwsUtilities.EwsAssert(false, "ServiceRequestBase.ProcessWebException", "Exchange server supports requested version but request was invalid for that version");
                            break;
                        }
                    }
                    throw new ServiceResponseException(new ServiceResponse(soapFaultDetails));
                }
            } else {
                this.service.processHttpErrorResponse(req, webException);
            }
        }
    }

    protected SoapFaultDetails readSoapFault(EwsServiceXmlReader reader) {
        SoapFaultDetails soapFaultDetails = null;
        try {
            this.readXmlDeclaration(reader);
            reader.read();
            if (!reader.isStartElement() || !reader.getLocalName().equals("Envelope")) {
                return soapFaultDetails;
            }
            XmlNamespace soapNamespace = EwsUtilities.getNamespaceFromUri(reader.getNamespaceUri());
            if (soapNamespace == XmlNamespace.NotSpecified) {
                return soapFaultDetails;
            }
            reader.read();
            if (reader.isStartElement(soapNamespace, "Header")) {
                do {
                    reader.read();
                    if (!reader.isStartElement(XmlNamespace.Types, "ServerVersionInfo")) continue;
                    this.service.setServerInfo(ExchangeServerInfo.parse(reader));
                } while (!reader.isEndElement(soapNamespace, "Header"));
                reader.read();
            }
            if (reader.isStartElement(soapNamespace, "Body")) {
                do {
                    reader.read();
                    if (!reader.isStartElement(soapNamespace, "Fault")) continue;
                    soapFaultDetails = SoapFaultDetails.parse(reader, soapNamespace);
                } while (!reader.isEndElement(soapNamespace, "Body"));
            }
            reader.readEndElement(soapNamespace, "Envelope");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return soapFaultDetails;
    }

    protected HttpWebRequest validateAndEmitRequest(OutParam<HttpWebRequest> request) throws ServiceLocalException, Exception {
        this.validate();
        try {
            return this.emit(request);
        }
        catch (IOException e) {
            throw new ServiceRequestException(String.format(Strings.ServiceRequestFailed, e.getMessage()), e);
        }
        catch (HttpErrorException e) {
            if (null != request.getParam() && -1 != ((HttpWebRequest)request.getParam()).getResponseCode()) {
                this.processWebException(e, (HttpWebRequest)request.getParam());
            }
            throw new HttpErrorException(e.getMessage(), e.getHttpErrorCode());
        }
        catch (Exception e) {
            if (null != request.getParam() && -1 != ((HttpWebRequest)request.getParam()).getResponseCode()) {
                this.processWebException(e, (HttpWebRequest)request.getParam());
            }
            throw new ServiceRequestException(String.format(Strings.ServiceRequestFailed, e.getMessage()), e);
        }
    }

    private boolean isNullOrEmpty(String str) {
        return null == str || str.isEmpty();
    }

    private void readXmlDeclaration(EwsServiceXmlReader reader) throws Exception {
        try {
            reader.read(new XMLNodeType(7));
        }
        catch (XmlException ex) {
            throw new ServiceRequestException(Strings.ServiceResponseDoesNotContainXml, ex);
        }
        catch (ServiceXmlDeserializationException ex) {
            throw new ServiceRequestException(Strings.ServiceResponseDoesNotContainXml, ex);
        }
    }
}

