/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.HttpWebRequest;
import microsoft.exchange.webservices.data.OutParam;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceRequestBase;
import microsoft.exchange.webservices.data.ServiceRequestException;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.TraceFlags;

abstract class SimpleServiceRequestBase
extends ServiceRequestBase {
    protected SimpleServiceRequestBase(ExchangeService service) throws Exception {
        super(service);
    }

    protected Object internalExecute() throws ServiceLocalException, Exception {
        OutParam<HttpWebRequest> outParam = new OutParam<HttpWebRequest>();
        HttpWebRequest response = this.validateAndEmitRequest(outParam);
        try {
            Object object = this.readResponse(response);
            return object;
        }
        catch (IOException ex) {
            throw new ServiceRequestException(String.format(Strings.ServiceRequestFailed, ex.getMessage(), ex));
        }
        catch (Exception e) {
            if (response != null) {
                this.getService().traceHttpResponseHeaders(TraceFlags.EwsResponseHttpHeaders, response);
            }
            throw new ServiceRequestException(String.format(Strings.ServiceRequestFailed, e.getMessage()), e);
        }
        finally {
            try {
                response.close();
            }
            catch (Exception e2) {
                response = null;
            }
        }
    }

    private Object readResponse(HttpWebRequest response) throws Exception {
        Object serviceResponse;
        if (this.getService().isTraceEnabledFor(TraceFlags.EwsResponse)) {
            int data;
            ByteArrayOutputStream memoryStream = new ByteArrayOutputStream();
            InputStream serviceResponseStream = ServiceRequestBase.getResponseStream(response);
            while (-1 != (data = serviceResponseStream.read())) {
                memoryStream.write(data);
            }
            this.traceResponse(response, memoryStream);
            ByteArrayInputStream memoryStreamIn = new ByteArrayInputStream(memoryStream.toByteArray());
            EwsServiceXmlReader ewsXmlReader = new EwsServiceXmlReader(memoryStreamIn, this.getService());
            serviceResponse = this.readResponse(ewsXmlReader);
            serviceResponseStream.close();
            memoryStream.flush();
        } else {
            InputStream responseStream = ServiceRequestBase.getResponseStream(response);
            EwsServiceXmlReader ewsXmlReader = new EwsServiceXmlReader(responseStream, this.getService());
            serviceResponse = this.readResponse(ewsXmlReader);
        }
        return serviceResponse;
    }
}

