/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.Date;
import microsoft.exchange.webservices.data.ArgumentException;
import microsoft.exchange.webservices.data.Strings;

final class Time {
    private int hours;
    private int minutes;
    private int seconds;

    protected Time() {
    }

    protected Time(int minutes) throws ArgumentException {
        this();
        if (minutes < 0 || minutes >= 1440) {
            throw new ArgumentException(String.format("%s,%s", Strings.MinutesMustBeBetween0And1439, "minutes"));
        }
        this.hours = minutes / 60;
        this.minutes = minutes % 60;
        this.seconds = 0;
    }

    protected Time(Date dateTime) throws ArgumentException {
        this.setHours(dateTime.getHours());
        this.setMinutes(dateTime.getMinutes());
        this.setSeconds(dateTime.getSeconds());
    }

    protected Time(int hours, int minutes, int seconds) {
        this();
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
    }

    protected String toXSTime() {
        return String.format("%s,%s,%s,%s", "{0:00}:{1:00}:{2:00}", this.getHours(), this.getMinutes(), this.getSeconds());
    }

    protected int convertToMinutes() {
        return this.getMinutes() + this.getHours() * 60;
    }

    protected int getHours() {
        return this.hours;
    }

    protected void setHours(int value) throws ArgumentException {
        if (value < 0 || value >= 24) {
            throw new ArgumentException(Strings.HourMustBeBetween0And23);
        }
        this.hours = value;
    }

    protected int getMinutes() {
        return this.minutes;
    }

    protected void setMinutes(int value) throws ArgumentException {
        if (value < 0 || value >= 60) {
            throw new ArgumentException(Strings.MinuteMustBeBetween0And59);
        }
        this.minutes = value;
    }

    protected int getSeconds() {
        return this.seconds;
    }

    protected void setSeconds(int value) throws ArgumentException {
        if (value < 0 || value >= 60) {
            throw new ArgumentException(Strings.SecondMustBeBetween0And59);
        }
        this.seconds = value;
    }
}

