/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.Date;
import java.util.EnumSet;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.PropertyBag;
import microsoft.exchange.webservices.data.PropertyDefinition;
import microsoft.exchange.webservices.data.PropertyDefinitionFlags;
import microsoft.exchange.webservices.data.XmlNamespace;

class DateTimePropertyDefinition
extends PropertyDefinition {
    private boolean isNullable;

    protected DateTimePropertyDefinition(String xmlElementName, String uri, ExchangeVersion version) {
        super(xmlElementName, uri, version);
    }

    protected DateTimePropertyDefinition(String xmlElementName, String uri, EnumSet<PropertyDefinitionFlags> flags, ExchangeVersion version) {
        super(xmlElementName, uri, flags, version);
    }

    protected DateTimePropertyDefinition(String xmlElementName, String uri, EnumSet<PropertyDefinitionFlags> flags, ExchangeVersion version, boolean isNullable) {
        super(xmlElementName, uri, flags, version);
        this.isNullable = isNullable;
    }

    @Override
    protected void loadPropertyValueFromXml(EwsServiceXmlReader reader, PropertyBag propertyBag) throws Exception {
        String value = reader.readElementValue(XmlNamespace.Types, this.getXmlElement());
        propertyBag.setObjectFromPropertyDefinition(this, reader.getService().convertUniversalDateTimeStringToDate(value));
    }

    @Override
    protected void writePropertyValueToXml(EwsServiceXmlWriter writer, PropertyBag propertyBag, boolean isUpdateOperation) throws Exception {
        Object value = propertyBag.getObjectFromPropertyDefinition(this);
        if (value != null) {
            writer.writeStartElement(XmlNamespace.Types, this.getXmlElement());
            Date dateTime = (Date)value;
            writer.writeValue(EwsUtilities.dateTimeToXSDateTime(dateTime), this.getName());
            writer.writeEndElement();
        }
    }

    @Override
    protected boolean isNullable() {
        return this.isNullable;
    }

    @Override
    public Class getType() {
        return Date.class;
    }
}

