/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.ComplexProperty;
import microsoft.exchange.webservices.data.DictionaryEntryProperty;
import microsoft.exchange.webservices.data.EditorBrowsable;
import microsoft.exchange.webservices.data.EditorBrowsableState;
import microsoft.exchange.webservices.data.EmailAddress;
import microsoft.exchange.webservices.data.EmailAddressKey;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.IComplexPropertyChangedDelegate;
import microsoft.exchange.webservices.data.MailboxType;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;

@EditorBrowsable(state=EditorBrowsableState.Never)
public final class EmailAddressEntry
extends DictionaryEntryProperty<EmailAddressKey>
implements IComplexPropertyChangedDelegate {
    private EmailAddress emailAddress;

    protected EmailAddressEntry() {
        super(EmailAddressKey.class);
        this.emailAddress = new EmailAddress();
        this.emailAddress.addOnChangeEvent(this);
    }

    protected EmailAddressEntry(EmailAddressKey key, EmailAddress emailAddress) {
        super(EmailAddressKey.class, key);
        this.emailAddress = emailAddress;
    }

    @Override
    protected void readAttributesFromXml(EwsServiceXmlReader reader) throws Exception {
        super.readAttributesFromXml(reader);
        this.getEmailAddress().setName(reader.readAttributeValue("Name"));
        this.getEmailAddress().setRoutingType(reader.readAttributeValue("RoutingType"));
        String mailboxTypeString = reader.readAttributeValue("MailboxType");
        if (mailboxTypeString != null && !mailboxTypeString.isEmpty()) {
            this.getEmailAddress().setMailboxType(EwsUtilities.parse(MailboxType.class, mailboxTypeString));
        } else {
            this.getEmailAddress().setMailboxType(null);
        }
    }

    @Override
    protected void readTextValueFromXml(EwsServiceXmlReader reader) throws Exception {
        this.getEmailAddress().setAddress(reader.readValue());
    }

    @Override
    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        super.writeAttributesToXml(writer);
        if (writer.getService().getRequestedServerVersion().ordinal() > ExchangeVersion.Exchange2007_SP1.ordinal()) {
            writer.writeAttributeValue("Name", this.getEmailAddress().getName());
            writer.writeAttributeValue("RoutingType", this.getEmailAddress().getRoutingType());
            if (this.getEmailAddress().getMailboxType() != MailboxType.Unknown) {
                writer.writeAttributeValue("MailboxType", (Object)this.getEmailAddress().getMailboxType());
            }
        }
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        writer.writeValue(this.getEmailAddress().getAddress(), "EmailAddress");
    }

    public EmailAddress getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(Object value) {
        if (this.canSetFieldValue(this.emailAddress, value)) {
            this.emailAddress = (EmailAddress)value;
        }
    }

    private void emailAddressChanged(ComplexProperty complexProperty) {
        this.changed();
    }

    @Override
    public void complexPropertyChanged(ComplexProperty complexProperty) {
        this.emailAddressChanged(complexProperty);
    }
}

