/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import microsoft.exchange.webservices.data.EmailAddress;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.XmlNamespace;

public final class ExpandGroupResults
implements Iterable<EmailAddress> {
    private boolean includesAllMembers;
    private Collection<EmailAddress> members = new ArrayList<EmailAddress>();

    protected ExpandGroupResults() {
    }

    public int getCount() {
        return this.getMembers().size();
    }

    public boolean getIncludesAllMembers() {
        return this.includesAllMembers;
    }

    public Collection<EmailAddress> getMembers() {
        return this.members;
    }

    protected void loadFromXml(EwsServiceXmlReader reader) throws Exception {
        reader.readStartElement(XmlNamespace.Messages, "DLExpansion");
        if (!reader.isEmptyElement()) {
            int totalItemsInView = reader.readAttributeValue(Integer.class, "TotalItemsInView");
            this.includesAllMembers = reader.readAttributeValue(Boolean.class, "IncludesLastItemInRange");
            for (int i = 0; i < totalItemsInView; ++i) {
                EmailAddress emailAddress = new EmailAddress();
                reader.readStartElement(XmlNamespace.Types, "Mailbox");
                emailAddress.loadFromXml(reader, "Mailbox");
                this.getMembers().add(emailAddress);
            }
            reader.readEndElement(XmlNamespace.Messages, "DLExpansion");
        } else {
            reader.read();
        }
    }

    @Override
    public Iterator<EmailAddress> iterator() {
        return this.members.iterator();
    }
}

