/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.ConversationIndexedItemView;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.FindConversationResponse;
import microsoft.exchange.webservices.data.FolderIdWrapper;
import microsoft.exchange.webservices.data.SearchFilter;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.SimpleServiceRequestBase;
import microsoft.exchange.webservices.data.XmlNamespace;

final class FindConversationRequest
extends SimpleServiceRequestBase {
    private ConversationIndexedItemView view;
    private SearchFilter.IsEqualTo searchFilter;
    private FolderIdWrapper folderId;

    protected FindConversationRequest(ExchangeService service) throws Exception {
        super(service);
    }

    protected ConversationIndexedItemView getIndexedItemView() {
        return this.view;
    }

    protected void setIndexedItemView(ConversationIndexedItemView value) {
        this.view = value;
    }

    protected SearchFilter.IsEqualTo getConversationViewFilter() {
        return this.searchFilter;
    }

    protected void setConversationViewFilter(SearchFilter.IsEqualTo value) {
        this.searchFilter = value;
    }

    protected FolderIdWrapper getFolderId() {
        return this.folderId;
    }

    protected void setFolderId(FolderIdWrapper value) {
        this.folderId = value;
    }

    @Override
    protected void validate() throws ServiceLocalException, Exception {
        super.validate();
        this.view.internalValidate(this);
    }

    @Override
    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        super.writeAttributesToXml(writer);
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        this.getIndexedItemView().writeToXml(writer);
        if (this.getConversationViewFilter() != null) {
            writer.writeStartElement(XmlNamespace.Messages, "Restriction");
            this.getConversationViewFilter().writeToXml(writer);
            writer.writeEndElement();
        }
        this.getIndexedItemView().writeOrderByToXml(writer);
        writer.writeStartElement(XmlNamespace.Messages, "ParentFolderId");
        this.getFolderId().writeToXml(writer);
        writer.writeEndElement();
    }

    @Override
    protected Object parseResponse(EwsServiceXmlReader reader) throws Exception {
        FindConversationResponse response = new FindConversationResponse();
        response.loadFromXml(reader, "FindConversationResponse");
        return response;
    }

    @Override
    protected String getXmlElementName() {
        return "FindConversation";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "FindConversationResponse";
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2010_SP1;
    }

    protected FindConversationResponse execute() throws ServiceLocalException, Exception {
        FindConversationResponse serviceResponse = (FindConversationResponse)this.internalExecute();
        serviceResponse.throwIfNecessary();
        return serviceResponse;
    }
}

