/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.Base64EncoderStream;
import microsoft.exchange.webservices.data.ComplexProperty;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.ServiceXmlDeserializationException;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;

public final class MimeContent
extends ComplexProperty {
    private String characterSet;
    private byte[] content;

    public MimeContent() {
    }

    public MimeContent(String characterSet, byte[] content) {
        this();
        this.characterSet = characterSet;
        this.content = content;
    }

    @Override
    protected void readAttributesFromXml(EwsServiceXmlReader reader) throws Exception {
        this.characterSet = reader.readAttributeValue(String.class, "CharacterSet");
    }

    @Override
    protected void readTextValueFromXml(EwsServiceXmlReader reader) throws XMLStreamException, ServiceXmlDeserializationException {
        this.content = Base64EncoderStream.decode(reader.readValue());
    }

    @Override
    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        writer.writeAttributeValue("CharacterSet", this.characterSet);
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws XMLStreamException {
        if (this.content != null && this.content.length > 0) {
            writer.writeBase64ElementValue(this.content);
        }
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public void setCharacterSet(String characterSet) {
        this.canSetFieldValue(this.characterSet, characterSet);
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.canSetFieldValue(this.content, content);
    }

    public String toString() {
        if (this.getContent() == null) {
            return "";
        }
        try {
            String charSet = this.getCharacterSet() == null || this.getCharacterSet().isEmpty() ? "UTF-8" : this.getCharacterSet();
            return new String(this.getContent(), charSet);
        }
        catch (Exception e) {
            return Base64EncoderStream.encode(this.getContent());
        }
    }
}

