/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.Folder;
import microsoft.exchange.webservices.data.FolderIdWrapperList;
import microsoft.exchange.webservices.data.MoveCopyRequest;
import microsoft.exchange.webservices.data.ServiceErrorHandling;
import microsoft.exchange.webservices.data.ServiceResponse;
import microsoft.exchange.webservices.data.XmlNamespace;

abstract class MoveCopyFolderRequest<TResponse extends ServiceResponse>
extends MoveCopyRequest<Folder, TResponse> {
    private FolderIdWrapperList folderIds = new FolderIdWrapperList();

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParamCollection(this.getFolderIds().iterator(), "FolderIds");
        this.getFolderIds().validate(this.getService().getRequestedServerVersion());
    }

    protected MoveCopyFolderRequest(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    @Override
    protected void writeIdsToXml(EwsServiceXmlWriter writer) {
        try {
            this.folderIds.writeToXml(writer, XmlNamespace.Messages, "FolderIds");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return this.getFolderIds().getCount();
    }

    protected FolderIdWrapperList getFolderIds() {
        return this.folderIds;
    }
}

