/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.Date;
import microsoft.exchange.webservices.data.AffectedTaskOccurrence;
import microsoft.exchange.webservices.data.Attachable;
import microsoft.exchange.webservices.data.ConflictResolutionMode;
import microsoft.exchange.webservices.data.DeleteMode;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.Item;
import microsoft.exchange.webservices.data.ItemAttachment;
import microsoft.exchange.webservices.data.ItemId;
import microsoft.exchange.webservices.data.MessageDisposition;
import microsoft.exchange.webservices.data.PropertySet;
import microsoft.exchange.webservices.data.Recurrence;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceObjectDefinition;
import microsoft.exchange.webservices.data.ServiceObjectSchema;
import microsoft.exchange.webservices.data.ServiceResponseException;
import microsoft.exchange.webservices.data.StringList;
import microsoft.exchange.webservices.data.TaskDelegationState;
import microsoft.exchange.webservices.data.TaskMode;
import microsoft.exchange.webservices.data.TaskSchema;
import microsoft.exchange.webservices.data.TaskStatus;

@Attachable
@ServiceObjectDefinition(xmlElementName="Task")
public class Task
extends Item {
    public Task(ExchangeService service) throws Exception {
        super(service);
    }

    protected Task(ItemAttachment parentAttachment) throws Exception {
        super(parentAttachment);
    }

    public static Task bind(ExchangeService service, ItemId id, PropertySet propertySet) throws Exception {
        return service.bindToItem(Task.class, id, propertySet);
    }

    public static Task bind(ExchangeService service, ItemId id) throws Exception {
        return Task.bind(service, id, PropertySet.getFirstClassProperties());
    }

    @Override
    protected ServiceObjectSchema getSchema() {
        return TaskSchema.Instance;
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    @Override
    protected boolean getIsTimeZoneHeaderRequired(boolean isUpdateOperation) {
        return true;
    }

    public void deleteCurrentOccurrence(DeleteMode deleteMode) throws ServiceLocalException, Exception {
        this.internalDelete(deleteMode, null, AffectedTaskOccurrence.SpecifiedOccurrenceOnly);
    }

    public Task updateTask(ConflictResolutionMode conflictResolutionMode) throws ServiceResponseException, Exception {
        return (Task)this.internalUpdate(null, conflictResolutionMode, MessageDisposition.SaveOnly, null);
    }

    public Integer getActualWork() throws ServiceLocalException {
        return (Integer)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.ActualWork);
    }

    public void setActualWork(Integer value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(TaskSchema.ActualWork, value);
    }

    public Date getAssignedTime() throws ServiceLocalException {
        return (Date)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.AssignedTime);
    }

    public String getBillingInformation() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.BillingInformation);
    }

    public void setBillingInformation(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(TaskSchema.BillingInformation, value);
    }

    public Integer getChangeCount() throws ServiceLocalException {
        return (Integer)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.ChangeCount);
    }

    public StringList getCompanies() throws ServiceLocalException {
        return (StringList)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.Companies);
    }

    public void setCompanies(StringList value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(TaskSchema.Companies, value);
    }

    public Date getCompleteDate() throws ServiceLocalException {
        return (Date)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.CompleteDate);
    }

    public void setCompleteDate(Date value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(TaskSchema.CompleteDate, value);
    }

    public StringList getContacts() throws ServiceLocalException {
        return (StringList)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.Contacts);
    }

    public void setContacts(StringList value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(TaskSchema.Contacts, value);
    }

    public TaskDelegationState getDelegationState() throws ServiceLocalException {
        return (TaskDelegationState)((Object)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.DelegationState));
    }

    public String getDelegator() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.Delegator);
    }

    public Date getDueDate() throws ServiceLocalException {
        return (Date)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.DueDate);
    }

    public void setDueDate(Date value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(TaskSchema.DueDate, value);
    }

    public TaskMode getMode() throws ServiceLocalException {
        return (TaskMode)((Object)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.Mode));
    }

    public Boolean getIsComplete() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.IsComplete);
    }

    public Boolean getIsRecurring() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.IsRecurring);
    }

    public Boolean getIsTeamTask() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.IsTeamTask);
    }

    public String getMileage() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.Mileage);
    }

    public void setMileage(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(TaskSchema.Mileage, value);
    }

    public String getOwner() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.Owner);
    }

    public Double getPercentComplete() throws ServiceLocalException {
        return (Double)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.PercentComplete);
    }

    public void setPercentComplete(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(TaskSchema.PercentComplete, value);
    }

    public Recurrence getRecurrence() throws ServiceLocalException {
        return (Recurrence)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.Recurrence);
    }

    public void setRecurrence(Recurrence value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(TaskSchema.Recurrence, value);
    }

    public Date getStartDate() throws ServiceLocalException {
        return (Date)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.StartDate);
    }

    public void setStartDate(Date value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(TaskSchema.StartDate, value);
    }

    public TaskStatus getStatus() throws ServiceLocalException {
        return (TaskStatus)((Object)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.Status));
    }

    public void setStatus(TaskStatus value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(TaskSchema.Status, (Object)value);
    }

    public String getStatusDescription() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.StatusDescription);
    }

    public Integer getTotalWork() throws ServiceLocalException {
        return (Integer)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.TotalWork);
    }

    public void setTotalWork(Integer value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(TaskSchema.TotalWork, value);
    }

    @Override
    protected AffectedTaskOccurrence getDefaultAffectedTaskOccurrences() {
        return AffectedTaskOccurrence.AllOccurrences;
    }
}

