/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.IGetObjectInstanceDelegate;
import microsoft.exchange.webservices.data.Item;
import microsoft.exchange.webservices.data.ServiceObject;
import microsoft.exchange.webservices.data.ServiceResponse;
import microsoft.exchange.webservices.data.ServiceResult;
import microsoft.exchange.webservices.data.ServiceXmlDeserializationException;
import microsoft.exchange.webservices.data.XmlNamespace;

public final class UpdateItemResponse
extends ServiceResponse
implements IGetObjectInstanceDelegate {
    private Item item;
    private Item returnedItem;
    private int conflictCount;

    protected UpdateItemResponse(Item item) {
        EwsUtilities.EwsAssert(item != null, "UpdateItemResponse.ctor", "item is null");
        this.item = item;
    }

    @Override
    protected void readElementsFromXml(EwsServiceXmlReader reader) throws ServiceXmlDeserializationException, XMLStreamException, InstantiationException, IllegalAccessException, Exception {
        super.readElementsFromXml(reader);
        reader.readServiceObjectsCollectionFromXml("Items", this, false, null, false);
        if (!reader.getService().getExchange2007CompatibilityMode()) {
            reader.readStartElement(XmlNamespace.Messages, "ConflictResults");
            this.conflictCount = reader.readElementValue(Integer.class, XmlNamespace.Types, "Count");
            reader.readEndElement(XmlNamespace.Messages, "ConflictResults");
        }
        if (this.returnedItem != null && this.item.getId().getUniqueId().equals(this.returnedItem.getId().getUniqueId())) {
            this.item.getId().setChangeKey(this.returnedItem.getId().getChangeKey());
            this.returnedItem = null;
        }
    }

    public ServiceObject getObjectInstanceDelegate(ExchangeService service, String xmlElementName) throws Exception {
        return this.getObjectInstance(service, xmlElementName);
    }

    @Override
    protected void loaded() {
        if (this.getResult() == ServiceResult.Success) {
            this.item.clearChangeLog();
        }
    }

    private Item getObjectInstance(ExchangeService service, String xmlElementName) throws Exception {
        this.returnedItem = (Item)EwsUtilities.createEwsObjectFromXmlElementName(Item.class, service, xmlElementName);
        return this.returnedItem;
    }

    public Item getReturnedItem() {
        return this.returnedItem;
    }

    public int getConflictCount() {
        return this.conflictCount;
    }
}

