/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.Base64EncoderStream;
import microsoft.exchange.webservices.data.ComplexProperty;
import microsoft.exchange.webservices.data.EditorBrowsable;
import microsoft.exchange.webservices.data.EditorBrowsableState;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.OutParam;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.UserConfigurationDictionaryObjectType;
import microsoft.exchange.webservices.data.XmlNamespace;

@EditorBrowsable(state=EditorBrowsableState.Never)
public final class UserConfigurationDictionary
extends ComplexProperty
implements Iterable<Object> {
    private Map<Object, Object> dictionary = new HashMap<Object, Object>();
    private boolean isDirty = false;

    protected UserConfigurationDictionary() {
    }

    public Object getElements(Object key) {
        return this.dictionary.get(key);
    }

    public void setElements(Object key, Object value) throws Exception {
        this.validateEntry(key, value);
        this.dictionary.put(key, value);
        this.changed();
    }

    public void addElement(Object key, Object value) throws Exception {
        this.validateEntry(key, value);
        this.dictionary.put(key, value);
        this.changed();
    }

    public boolean containsKey(Object key) {
        return this.dictionary.containsKey(key);
    }

    public boolean remove(Object key) {
        boolean isRemoved = false;
        if (key != null) {
            this.dictionary.remove(key);
            isRemoved = true;
        }
        if (isRemoved) {
            this.changed();
        }
        return isRemoved;
    }

    public boolean tryGetValue(Object key, OutParam<Object> value) {
        if (this.dictionary.containsKey(key)) {
            value.setParam(this.dictionary.get(key));
            return true;
        }
        value.setParam((Object)null);
        return false;
    }

    public int getCount() {
        return this.dictionary.size();
    }

    public void clear() {
        if (this.dictionary.size() != 0) {
            this.dictionary.clear();
            this.changed();
        }
    }

    public Iterator getEnumerator() {
        return this.dictionary.values().iterator();
    }

    protected boolean getIsDirty() {
        return this.isDirty;
    }

    protected void setIsDirty(boolean value) {
        this.isDirty = value;
    }

    @Override
    protected void changed() {
        super.changed();
        this.isDirty = true;
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        EwsUtilities.EwsAssert(writer != null, "UserConfigurationDictionary.WriteElementsToXml", "writer is null");
        for (Map.Entry<Object, Object> dictionaryEntry : this.dictionary.entrySet()) {
            writer.writeStartElement(XmlNamespace.Types, "DictionaryEntry");
            this.writeObjectToXml(writer, "DictionaryKey", dictionaryEntry.getKey());
            this.writeObjectToXml(writer, "DictionaryValue", dictionaryEntry.getValue());
            writer.writeEndElement();
        }
    }

    private void writeObjectToXml(EwsServiceXmlWriter writer, String xmlElementName, Object dictionaryObject) throws XMLStreamException, ServiceXmlSerializationException {
        EwsUtilities.EwsAssert(writer != null, "UserConfigurationDictionary.WriteObjectToXml", "writer is null");
        EwsUtilities.EwsAssert(xmlElementName != null, "UserConfigurationDictionary.WriteObjectToXml", "xmlElementName is null");
        writer.writeStartElement(XmlNamespace.Types, xmlElementName);
        if (dictionaryObject == null) {
            EwsUtilities.EwsAssert(!xmlElementName.equals("DictionaryKey"), "UserConfigurationDictionary.WriteObjectToXml", "Key is null");
            writer.writeAttributeValue("xsi", "nil", (Object)"true");
        } else {
            this.writeObjectValueToXml(writer, dictionaryObject);
        }
        writer.writeEndElement();
    }

    private void writeObjectValueToXml(EwsServiceXmlWriter writer, Object dictionaryObject) throws XMLStreamException, ServiceXmlSerializationException {
        EwsUtilities.EwsAssert(writer != null, "UserConfigurationDictionary.WriteObjectValueToXml", "writer is null");
        EwsUtilities.EwsAssert(dictionaryObject != null, "UserConfigurationDictionary.WriteObjectValueToXml", "dictionaryObject is null");
        String[] dictionaryObjectAsStringArray = null;
        byte[] dictionaryObjectAsByteArray = null;
        if (dictionaryObject != null) {
            dictionaryObjectAsStringArray = (String[])dictionaryObject;
            dictionaryObjectAsByteArray = (byte[])dictionaryObject;
        }
        if (dictionaryObjectAsStringArray != null) {
            this.writeEntryTypeToXml(writer, UserConfigurationDictionaryObjectType.StringArray);
            for (String arrayElement : dictionaryObjectAsStringArray) {
                this.writeEntryValueToXml(writer, arrayElement);
            }
        } else {
            UserConfigurationDictionaryObjectType dictionaryObjectType = UserConfigurationDictionaryObjectType.String;
            String valueAsString = null;
            if (dictionaryObjectAsByteArray != null) {
                dictionaryObjectType = UserConfigurationDictionaryObjectType.ByteArray;
                valueAsString = Base64EncoderStream.encode(dictionaryObjectAsByteArray);
            } else if (dictionaryObject.getClass().equals(Boolean.TYPE)) {
                dictionaryObjectType = UserConfigurationDictionaryObjectType.Boolean;
                valueAsString = EwsUtilities.boolToXSBool((Boolean)dictionaryObject);
            } else if (dictionaryObject.getClass().equals(Byte.TYPE)) {
                dictionaryObjectType = UserConfigurationDictionaryObjectType.Byte;
                valueAsString = ((Byte)dictionaryObject).toString();
            } else if (dictionaryObject.getClass().equals(Date.class)) {
                dictionaryObjectType = UserConfigurationDictionaryObjectType.DateTime;
                valueAsString = writer.getService().convertDateTimeToUniversalDateTimeString((Date)dictionaryObject);
            } else if (dictionaryObject.getClass().equals(Integer.TYPE)) {
                dictionaryObjectType = UserConfigurationDictionaryObjectType.Integer32;
                valueAsString = ((Integer)dictionaryObject).toString();
            } else if (dictionaryObject.getClass().equals(Long.TYPE)) {
                dictionaryObjectType = UserConfigurationDictionaryObjectType.Integer64;
                valueAsString = ((Long)dictionaryObject).toString();
            } else if (dictionaryObject.getClass().equals(String.class)) {
                dictionaryObjectType = UserConfigurationDictionaryObjectType.String;
                valueAsString = (String)dictionaryObject;
            } else if (dictionaryObject.getClass().equals(Integer.TYPE)) {
                dictionaryObjectType = UserConfigurationDictionaryObjectType.UnsignedInteger32;
                valueAsString = ((Integer)dictionaryObject).toString();
            } else if (dictionaryObject.getClass().equals(Long.TYPE)) {
                dictionaryObjectType = UserConfigurationDictionaryObjectType.UnsignedInteger64;
                valueAsString = ((Long)dictionaryObject).toString();
            } else {
                EwsUtilities.EwsAssert(false, "UserConfigurationDictionary.WriteObjectValueToXml", "Unsupported type: " + dictionaryObject.getClass().toString());
            }
            this.writeEntryTypeToXml(writer, dictionaryObjectType);
            this.writeEntryValueToXml(writer, valueAsString);
        }
    }

    private void writeEntryTypeToXml(EwsServiceXmlWriter writer, UserConfigurationDictionaryObjectType dictionaryObjectType) throws XMLStreamException, ServiceXmlSerializationException {
        writer.writeStartElement(XmlNamespace.Types, "Type");
        writer.writeValue(dictionaryObjectType.toString(), "Type");
        writer.writeEndElement();
    }

    private void writeEntryValueToXml(EwsServiceXmlWriter writer, String value) throws XMLStreamException, ServiceXmlSerializationException {
        writer.writeStartElement(XmlNamespace.Types, "Value");
        if (value != null) {
            writer.writeValue(value, "Value");
        }
        writer.writeEndElement();
    }

    @Override
    protected void loadFromXml(EwsServiceXmlReader reader, XmlNamespace xmlNamespace, String xmlElementName) throws Exception {
        super.loadFromXml(reader, xmlNamespace, xmlElementName);
        this.isDirty = false;
    }

    @Override
    protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        reader.ensureCurrentNodeIsStartElement(this.getNamespace(), "DictionaryEntry");
        this.loadEntry(reader);
        return true;
    }

    private void loadEntry(EwsServiceXmlReader reader) throws Exception {
        boolean hasValue;
        EwsUtilities.EwsAssert(reader != null, "UserConfigurationDictionary.LoadEntry", "reader is null");
        Object value = null;
        reader.readStartElement(this.getNamespace(), "DictionaryKey");
        Object key = this.getDictionaryObject(reader);
        reader.readStartElement(this.getNamespace(), "DictionaryValue");
        String nil = reader.readAttributeValue(XmlNamespace.XmlSchemaInstance, "nil");
        boolean bl = hasValue = nil == null || !nil.getClass().equals(Boolean.TYPE);
        if (hasValue) {
            value = this.getDictionaryObject(reader);
        }
        this.dictionary.put(key, value);
    }

    private Object getDictionaryObject(EwsServiceXmlReader reader) throws Exception {
        EwsUtilities.EwsAssert(reader != null, "UserConfigurationDictionary.loadFromXml", "reader is null");
        UserConfigurationDictionaryObjectType type = this.getObjectType(reader);
        List<String> values = this.getObjectValue(reader, type);
        return this.constructObject(type, values, reader);
    }

    private List<String> getObjectValue(EwsServiceXmlReader reader, UserConfigurationDictionaryObjectType type) throws Exception {
        EwsUtilities.EwsAssert(reader != null, "UserConfigurationDictionary.LoadFromXml", "reader is null");
        ArrayList<String> values = new ArrayList<String>();
        reader.readStartElement(this.getNamespace(), "Value");
        do {
            String value = null;
            if (reader.isEmptyElement()) {
                if (type.equals((Object)UserConfigurationDictionaryObjectType.String) || type.equals((Object)UserConfigurationDictionaryObjectType.StringArray)) {
                    value = "";
                } else {
                    EwsUtilities.EwsAssert(false, "UserConfigurationDictionary.GetObjectValue", "Empty element passed for type: " + type.toString());
                }
            } else {
                value = reader.readElementValue();
            }
            values.add(value);
            reader.read();
        } while (reader.isStartElement(this.getNamespace(), "Value"));
        return values;
    }

    private UserConfigurationDictionaryObjectType getObjectType(EwsServiceXmlReader reader) throws Exception {
        EwsUtilities.EwsAssert(reader != null, "UserConfigurationDictionary.LoadFromXml", "reader is null");
        reader.readStartElement(this.getNamespace(), "Type");
        String type = reader.readElementValue();
        return UserConfigurationDictionaryObjectType.valueOf(type);
    }

    private Object constructObject(UserConfigurationDictionaryObjectType type, List<String> value, EwsServiceXmlReader reader) {
        EwsUtilities.EwsAssert(value != null, "UserConfigurationDictionary.ConstructObject", "value is null");
        EwsUtilities.EwsAssert(value.size() == 1 || type == UserConfigurationDictionaryObjectType.StringArray, "UserConfigurationDictionary.ConstructObject", "value is array but type is not StringArray");
        EwsUtilities.EwsAssert(reader != null, "UserConfigurationDictionary.ConstructObject", "reader is null");
        Object dictionaryObject = null;
        if (type.equals((Object)UserConfigurationDictionaryObjectType.Boolean)) {
            dictionaryObject = Boolean.parseBoolean(value.get(0));
        } else if (type.equals((Object)UserConfigurationDictionaryObjectType.Byte)) {
            dictionaryObject = Byte.parseByte(value.get(0));
        } else if (type.equals((Object)UserConfigurationDictionaryObjectType.ByteArray)) {
            dictionaryObject = Base64EncoderStream.decode(value.get(0));
        } else if (type.equals((Object)UserConfigurationDictionaryObjectType.DateTime)) {
            Date dateTime = reader.getService().convertUniversalDateTimeStringToDate(value.get(0));
            if (dateTime != null) {
                dictionaryObject = dateTime;
            } else {
                EwsUtilities.EwsAssert(false, "UserConfigurationDictionary.ConstructObject", "DateTime is null");
            }
        } else if (type.equals((Object)UserConfigurationDictionaryObjectType.Integer32)) {
            dictionaryObject = Integer.parseInt(value.get(0));
        } else if (type.equals((Object)UserConfigurationDictionaryObjectType.Integer64)) {
            dictionaryObject = Long.parseLong(value.get(0));
        } else if (type.equals((Object)UserConfigurationDictionaryObjectType.String)) {
            dictionaryObject = String.valueOf(value.get(0));
        } else if (type.equals((Object)UserConfigurationDictionaryObjectType.StringArray)) {
            dictionaryObject = value.toArray();
        } else if (type.equals((Object)UserConfigurationDictionaryObjectType.UnsignedInteger32)) {
            dictionaryObject = Integer.parseInt(value.get(0));
        } else if (type.equals((Object)UserConfigurationDictionaryObjectType.UnsignedInteger64)) {
            dictionaryObject = Long.parseLong(value.get(0));
        } else {
            EwsUtilities.EwsAssert(false, "UserConfigurationDictionary.ConstructObject", "Type not recognized: " + type.toString());
        }
        return dictionaryObject;
    }

    private void validateEntry(Object key, Object value) throws Exception {
        this.validateObject(key);
        this.validateObject(value);
    }

    private void validateObject(Object dictionaryObject) throws Exception {
        if (dictionaryObject != null) {
            if (dictionaryObject.getClass().isArray()) {
                int length = Array.getLength(dictionaryObject);
                Class<?> wrapperType = Array.get(dictionaryObject, 0).getClass();
                Object[] newArray = (Object[])Array.newInstance(wrapperType, length);
                for (int i = 0; i < length; ++i) {
                    newArray[i] = Array.get(dictionaryObject, i);
                }
                this.validateArrayObject(newArray);
            } else {
                this.validateObjectType(dictionaryObject.getClass());
            }
        } else {
            throw new NullPointerException();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateArrayObject(Object[] dictionaryObjectAsArray) throws ServiceLocalException {
        if (dictionaryObjectAsArray instanceof String[]) {
            if (dictionaryObjectAsArray.length <= 0) throw new ServiceLocalException(Strings.ZeroLengthArrayInvalid);
            for (Object arrayElement : dictionaryObjectAsArray) {
                if (arrayElement != null) continue;
                throw new ServiceLocalException(Strings.NullStringArrayElementInvalid);
            }
            return;
        } else {
            if (!(dictionaryObjectAsArray instanceof Byte[])) throw new ServiceLocalException(String.format(Strings.ObjectTypeNotSupported, dictionaryObjectAsArray.getClass()));
            if (dictionaryObjectAsArray.length > 0) return;
            throw new ServiceLocalException(Strings.ZeroLengthArrayInvalid);
        }
    }

    private void validateObjectType(Type type) throws ServiceLocalException {
        boolean isValidType = false;
        if (type.equals(Boolean.TYPE) || type.equals(Byte.TYPE) || type.equals(Date.class) || type.equals(Integer.TYPE) || type.equals(Long.TYPE) || type.equals(String.class) || type.equals(Integer.TYPE) || type.equals(Long.TYPE)) {
            isValidType = true;
        }
        if (!isValidType) {
            throw new ServiceLocalException(String.format("%s,%s", Strings.ObjectTypeNotSupported, type));
        }
    }

    @Override
    public Iterator<Object> iterator() {
        return this.dictionary.values().iterator();
    }
}

