/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.EditorBrowsable;
import microsoft.exchange.webservices.data.EditorBrowsableState;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.Grouping;
import microsoft.exchange.webservices.data.PropertySet;
import microsoft.exchange.webservices.data.ServiceObjectType;
import microsoft.exchange.webservices.data.ServiceRequestBase;
import microsoft.exchange.webservices.data.ServiceValidationException;
import microsoft.exchange.webservices.data.ServiceVersionException;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.XmlNamespace;

@EditorBrowsable(state=EditorBrowsableState.Never)
public abstract class ViewBase {
    private PropertySet propertySet;

    ViewBase() {
    }

    protected void internalValidate(ServiceRequestBase request) throws ServiceValidationException, ServiceVersionException {
        if (this.getPropertySet() != null) {
            this.getPropertySet().internalValidate();
            this.getPropertySet().validateForRequest(request, true);
        }
    }

    protected void internalWriteViewToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException, Exception {
        Integer maxEntriesReturned = this.getMaxEntriesReturned();
        if (maxEntriesReturned != null) {
            writer.writeAttributeValue("MaxEntriesReturned", maxEntriesReturned);
        }
    }

    protected abstract void internalWriteSearchSettingsToXml(EwsServiceXmlWriter var1, Grouping var2) throws XMLStreamException, ServiceXmlSerializationException;

    protected abstract void writeOrderByToXml(EwsServiceXmlWriter var1) throws XMLStreamException, ServiceXmlSerializationException;

    protected abstract String getViewXmlElementName();

    protected abstract Integer getMaxEntriesReturned();

    protected abstract ServiceObjectType getServiceObjectType();

    protected abstract void writeAttributesToXml(EwsServiceXmlWriter var1) throws ServiceXmlSerializationException;

    protected void writeToXml(EwsServiceXmlWriter writer, Grouping groupBy) throws Exception {
        this.getPropertySetOrDefault().writeToXml(writer, this.getServiceObjectType());
        writer.writeStartElement(XmlNamespace.Messages, this.getViewXmlElementName());
        this.internalWriteViewToXml(writer);
        writer.writeEndElement();
        this.internalWriteSearchSettingsToXml(writer, groupBy);
    }

    protected PropertySet getPropertySetOrDefault() {
        if (this.getPropertySet() == null) {
            return PropertySet.getFirstClassProperties();
        }
        return this.getPropertySet();
    }

    public PropertySet getPropertySet() {
        return this.propertySet;
    }

    public void setPropertySet(PropertySet propertySet) {
        this.propertySet = propertySet;
    }
}

