/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeCredentials;

public abstract class WSSecurityBasedCredentials
extends ExchangeCredentials {
    private String securityToken;
    private URI ewsUrl;
    protected static final String WSSecuritySecExt10NamespacePrefix = "wsse";
    protected static final String WSSecuritySecExt10Namespace = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    protected static final String WSAddressing10NamespacePrefix = "wsa";
    protected static final String WSAddressing10Namespace = "http://www.w3.org/2005/08/addressing";
    protected static final String WsAddressingHeadersFormat = "<wsa:Action soap:mustUnderstand='1'>http://schemas.microsoft.com/exchange/services/2006/messages/%s</wsa:Action><wsa:ReplyTo><wsa:Address>http://www.w3.org/2005/08/addressing/anonymous</wsa:Address></wsa:ReplyTo><wsa:To soap:mustUnderstand='1'>%s</wsa:To>";
    protected static final String WsSecurityHeaderFormat = "<wsse:Security soap:mustUnderstand='1'>  %s</wsse:Security>";
    protected static final String WsSecurityPathSuffix = "/wssecurity";

    protected WSSecurityBasedCredentials() {
    }

    protected WSSecurityBasedCredentials(String securityToken) {
        this.securityToken = securityToken;
    }

    @Override
    protected void preAuthenticate() {
    }

    @Override
    protected void emitExtraSoapHeaderNamespaceAliases(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeAttribute("xmlns", WSSecuritySecExt10NamespacePrefix, null, WSSecuritySecExt10Namespace);
        writer.writeAttribute("xmlns", WSAddressing10NamespacePrefix, null, WSAddressing10Namespace);
    }

    @Override
    protected void serializeExtraSoapHeaders(XMLStreamWriter writer, String webMethodName) throws XMLStreamException {
        this.serializeWSAddressingHeaders(writer, webMethodName);
        this.serializeWSSecurityHeaders(writer);
    }

    private void serializeWSAddressingHeaders(XMLStreamWriter xmlWriter, String webMethodName) throws XMLStreamException {
        EwsUtilities.EwsAssert(webMethodName != null, "WSSecurityBasedCredentials.SerializeWSAddressingHeaders", "Web method name cannot be null!");
        EwsUtilities.EwsAssert(this.ewsUrl != null, "WSSecurityBasedCredentials.SerializeWSAddressingHeaders", "EWS Url cannot be null!");
        String wsAddressingHeaders = String.format(WsAddressingHeadersFormat, webMethodName, this.ewsUrl);
        xmlWriter.writeCharacters(wsAddressingHeaders);
    }

    @Override
    protected void serializeWSSecurityHeaders(XMLStreamWriter xmlWriter) throws XMLStreamException {
        EwsUtilities.EwsAssert(this.securityToken != null, "WSSecurityBasedCredentials.SerializeWSSecurityHeaders", "Security token cannot be null!");
        String wsSecurityHeader = String.format(WsSecurityHeaderFormat, this.securityToken);
        xmlWriter.writeCharacters(wsSecurityHeader);
    }

    @Override
    protected URI adjustUrl(URI url) throws URISyntaxException {
        return new URI(url.getHost() + WsSecurityPathSuffix);
    }

    protected String getSecurityToken() {
        return this.securityToken;
    }

    protected void setSecurityToken(String value) {
        this.securityToken = value;
    }

    protected URI getEwsUrl() {
        return this.ewsUrl;
    }

    protected void setEwsUrl(URI value) {
        this.ewsUrl = value;
    }
}

